/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.entity.EntityGem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class LayerGemPlacement
implements LayerRenderer<EntityGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final ModelBase gemModel;
    private final String name;
    private final boolean glow;

    public LayerGemPlacement(RenderLivingBase<?> gemRenderer) {
        this(gemRenderer, null);
    }

    public LayerGemPlacement(RenderLivingBase<?> gemRenderer, boolean glow) {
        this(gemRenderer, null, glow);
    }

    public LayerGemPlacement(RenderLivingBase<?> gemRenderer, String name) {
        this(gemRenderer, name, false);
    }

    public LayerGemPlacement(RenderLivingBase<?> gemRenderer, String name, boolean glow) {
        this.gemRenderer = gemRenderer;
        this.gemModel = gemRenderer.func_177087_b();
        this.name = name;
        this.glow = glow;
    }

    public void doRenderLayer(EntityGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!gem.isFusion()) {
            if (this.glow) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)61680.0f, (float)0.0f);
                GlStateManager.func_179145_e();
            }
            this.gemRenderer.func_110776_a(this.getTexture(gem));
            int color = gem.getGemColor();
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)((color & 0xFF) >> 0) / 255.0f;
            GlStateManager.func_179124_c((float)r, (float)g, (float)b);
            this.gemModel.func_178686_a(this.gemRenderer.func_177087_b());
            this.gemModel.func_78088_a((Entity)gem, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179084_k();
        }
    }

    public ResourceLocation getTexture(EntityGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/gems/" + gem.getGemPlacement().id + "_" + gem.getGemCut().id + ".png");
    }

    public String getName(EntityGem gem) {
        if (this.name == null) {
            ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
            if (loc.func_110624_b().equals("kagic")) {
                return loc.func_110623_a().replaceFirst("kagic.", "");
            }
            return loc.func_110623_a();
        }
        return this.name;
    }

    public boolean func_177142_b() {
        return true;
    }
}

