/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.entity.EntityFusionGem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class LayerFusionColor
implements LayerRenderer<EntityFusionGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final ModelBase gemModel;
    private float offset;
    private String name;

    public LayerFusionColor(RenderLivingBase<?> gemRenderer) {
        this(gemRenderer, 0.0f);
    }

    public LayerFusionColor(RenderLivingBase<?> gemRenderer, float offset) {
        this(gemRenderer, offset, null);
    }

    public LayerFusionColor(RenderLivingBase<?> gemRenderer, float offset, String name) {
        this.gemRenderer = gemRenderer;
        this.gemModel = gemRenderer.func_177087_b();
        this.offset = offset;
        this.name = name;
    }

    public void doRenderLayer(EntityFusionGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.gemRenderer.func_110776_a(this.getTexture(gem));
        int fusionColor = gem.getFusionColor();
        float r = (float)((fusionColor & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((fusionColor & 0xFF00) >> 8) / 255.0f;
        float b = (float)((fusionColor & 0xFF) >> 0) / 255.0f;
        GlStateManager.func_179131_c((float)(r + this.offset), (float)(g + this.offset), (float)(b + this.offset), (float)1.0f);
        this.gemModel.func_178686_a(this.gemRenderer.func_177087_b());
        this.gemModel.func_78088_a((Entity)gem, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179084_k();
    }

    public ResourceLocation getTexture(EntityFusionGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/fusion_color.png");
    }

    public String getName(EntityFusionGem gem) {
        if (this.name != null) {
            return this.name;
        }
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (loc.func_110624_b().equals("kagic")) {
            return loc.func_110623_a().replaceFirst("kagic.", "");
        }
        return loc.func_110623_a();
    }

    public boolean func_177142_b() {
        return true;
    }
}

