/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.render.layers;

import mod.akrivus.kagic.entity.EntityFusionGem;
import mod.akrivus.kagic.entity.EntityGem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class LayerCrossFusionGemPlacement
implements LayerRenderer<EntityFusionGem> {
    private final RenderLivingBase<?> gemRenderer;
    private final ModelBase gemModel;

    public LayerCrossFusionGemPlacement(RenderLivingBase<?> gemRendererIn) {
        this.gemRenderer = gemRendererIn;
        this.gemModel = gemRendererIn.func_177087_b();
    }

    public void doRenderLayer(EntityFusionGem gem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        int color = gem.getGemColor();
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        String[] types = gem.getFusionTypes().split(" ");
        String[] cutPlacements = gem.getFusionPlacements().split(" ");
        for (int i = 0; i < gem.getFusionCount(); ++i) {
            this.gemRenderer.func_110776_a(this.getTexture(gem, types[i], cutPlacements[i]));
            this.gemModel.func_178686_a(this.gemRenderer.func_177087_b());
            this.gemModel.func_78088_a((Entity)gem, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public ResourceLocation getTexture(EntityGem gem, String type, String cutPlacement) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        return new ResourceLocation(loc.func_110624_b() + ":textures/entities/" + this.getName(gem) + "/gems/" + type + "/" + cutPlacement + ".png");
    }

    public String getName(EntityGem gem) {
        ResourceLocation loc = EntityList.func_191301_a((Entity)gem);
        if (loc.func_110624_b().equals("kagic")) {
            return loc.func_110623_a().replaceFirst("kagic.", "");
        }
        return loc.func_110623_a();
    }

    public boolean func_177142_b() {
        return true;
    }
}

