/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.client.gui;

import java.util.Iterator;
import java.util.SortedMap;
import mod.akrivus.kagic.client.gui.GUIGalaxyPadSelection;
import mod.heimrarnadalr.kagic.networking.GalaxySignalMessage;
import mod.heimrarnadalr.kagic.networking.KTPacketHandler;
import mod.heimrarnadalr.kagic.worlddata.GalaxyPadLocation;
import mod.heimrarnadalr.kagic.worlddata.WarpPadDataEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GUIGalaxyPadList
extends GuiListExtended {
    private final Minecraft mc;
    private final GUIGalaxyPadSelection selectionScreen;
    private final GuiListExtended.IGuiListEntry[] padListEntries;

    public GUIGalaxyPadList(GUIGalaxyPadSelection parent, BlockPos sourcePos, SortedMap<Double, GalaxyPadLocation> positions, Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn + 30, bottomIn - 30, slotHeightIn);
        this.mc = mcIn;
        this.selectionScreen = parent;
        this.padListEntries = new GuiListExtended.IGuiListEntry[positions.size()];
        Iterator<GalaxyPadLocation> it = positions.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            GalaxyPadLocation gLoc = it.next();
            WarpPadDataEntry data = this.selectionScreen.getPadDataEntry(gLoc);
            this.padListEntries[i] = new PadListEntry(sourcePos, gLoc, data);
            ++i;
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.padListEntries[index];
    }

    protected int func_148127_b() {
        return this.padListEntries.length;
    }

    public class PadListEntry
    implements GuiListExtended.IGuiListEntry {
        private final BlockPos sourcePos;
        private final GalaxyPadLocation padPos;
        private final WarpPadDataEntry padData;
        private final GuiButton padButton;

        PadListEntry(BlockPos sourcePos, GalaxyPadLocation gLoc, WarpPadDataEntry data) {
            this.sourcePos = sourcePos;
            this.padPos = gLoc;
            this.padData = data;
            this.padButton = new GuiButton(0, 0, 0, 200, 20, this.padData.name);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.padButton.field_146128_h = ((GUIGalaxyPadList)GUIGalaxyPadList.this).mc.field_71462_r.field_146294_l / 2 - this.padButton.field_146120_f / 2;
            this.padButton.field_146129_i = y + 10;
            if (!this.padData.valid) {
                this.padButton.field_146126_j = TextFormatting.RED + this.padData.name;
                this.padButton.field_146124_l = false;
            } else if (!this.padData.clear) {
                this.padButton.field_146126_j = TextFormatting.YELLOW + this.padData.name;
                this.padButton.field_146124_l = false;
            } else {
                this.padButton.field_146126_j = TextFormatting.AQUA + this.padData.name;
            }
            this.padButton.func_191745_a(GUIGalaxyPadList.this.mc, mouseX, mouseY, partialTicks);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.padButton.func_146116_c(GUIGalaxyPadList.this.mc, mouseX, mouseY)) {
                KTPacketHandler.INSTANCE.sendToServer((IMessage)new GalaxySignalMessage(this.sourcePos, this.padPos));
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.padButton.func_146118_a(x, y);
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }
}

