/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.blocks;

import java.util.Random;
import mod.akrivus.kagic.blocks.BlockGemDrill;
import mod.akrivus.kagic.blocks.BlockIncubator;
import mod.akrivus.kagic.event.InjectionEvent;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModCreativeTabs;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.util.injector.Injector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInjector
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected final boolean isEquipped;
    protected final boolean analog;

    public BlockInjector(boolean isEquipped, boolean analog) {
        super(Material.field_151592_s, MapColor.field_151675_r);
        this.func_149663_c(analog ? "analog_injector" : "injector");
        this.isEquipped = isEquipped;
        this.analog = analog;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        if (this.isEquipped) {
            this.func_149715_a(0.5f);
        } else {
            this.func_149647_a(ModCreativeTabs.CREATIVE_TAB_OTHER);
        }
    }

    public void injectGemSeed(World worldIn, BlockPos pos) {
        if (!(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockIncubator)) {
            Injector.tellNearbyPlayers(worldIn, pos, "injector_missing_incubator", true);
        } else if (!(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGemDrill)) {
            Injector.tellNearbyPlayers(worldIn, pos, "injector_missing_drill", true);
        } else if (this.isEquipped) {
            int newPosY = 0;
            newPosY = this.analog ? this.calcDistanceUsingRedstoneSignals(worldIn, pos) : this.calcDistanceAutomatically(worldIn, pos);
            InjectionEvent e1 = new InjectionEvent(worldIn, pos, newPosY, true);
            if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
                return;
            }
            if (newPosY > 5) {
                worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), newPosY, pos.func_177952_p()), ModBlocks.GEM_SEED.func_176223_P());
                worldIn.func_175656_a(pos, ModBlocks.INJECTOR.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187715_dR, SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
                worldIn.func_184133_a(null, pos, ModSounds.BLOCK_INJECTOR_FIRE, SoundCategory.BLOCKS, 1000.0f, 1.0f);
                Injector.tellNearbyPlayers(worldIn, pos, "injector_success", false, pos.func_177958_n(), newPosY, pos.func_177952_p());
                Injector.awardNearbyPlayers(worldIn, pos);
            } else {
                Injector.tellNearbyPlayers(worldIn, pos, "injector_failure", true);
            }
        } else {
            Injector.tellNearbyPlayers(worldIn, pos, "injector_not_equipped", true);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        Injector.onInjectorPlacement(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
        if (worldIn.func_175640_z(pos) && this.isEquipped) {
            this.injectGemSeed(worldIn, pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (playerIn.func_70093_af()) {
                if (this.analog) {
                    if (!this.isEquipped) {
                        worldIn.func_175656_a(pos, ModBlocks.INJECTOR.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
                    }
                } else if (!this.isEquipped) {
                    worldIn.func_175656_a(pos, ModBlocks.ANALOG_INJECTOR.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
                }
            } else {
                IBlockState unequippedState = ModBlocks.INJECTOR.func_176223_P();
                IBlockState equippedState = ModBlocks.EQUIPPED_INJECTOR.func_176223_P();
                if (this.analog) {
                    unequippedState = ModBlocks.ANALOG_INJECTOR.func_176223_P();
                    equippedState = ModBlocks.EQUIPPED_ANALOG_INJECTOR.func_176223_P();
                }
                if (this.isEquipped && heldItem.func_190926_b()) {
                    worldIn.func_184133_a(null, pos, ModSounds.BLOCK_INJECTOR_OPEN, SoundCategory.BLOCKS, 0.3f, 1.0f);
                    worldIn.func_175656_a(pos, unequippedState.func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
                    EntityItem activatedBase = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((Item)ModItems.ACTIVATED_GEM_BASE));
                    worldIn.func_72838_d((Entity)activatedBase);
                } else if (!this.isEquipped && heldItem.func_77973_b() == ModItems.ACTIVATED_GEM_BASE) {
                    worldIn.func_175656_a(pos, equippedState.func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
                    worldIn.func_184133_a(null, pos, ModSounds.BLOCK_INJECTOR_CLOSE, SoundCategory.BLOCKS, 0.3f, 1.0f);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_77979_a(1);
                    }
                    Injector.onGemBasePlacement(worldIn, pos);
                }
                if (heldItem.func_77973_b() instanceof ItemBlock) {
                    return false;
                }
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        if (worldIn.func_175640_z(pos) && this.isEquipped) {
            this.injectGemSeed(worldIn, pos);
        }
    }

    public int calcDistanceUsingRedstoneSignals(World worldIn, BlockPos pos) {
        int totalPower = 6;
        totalPower += worldIn.func_180495_p(pos.func_177978_c()).func_185911_a((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.NORTH);
        totalPower += worldIn.func_180495_p(pos.func_177968_d()).func_185911_a((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.SOUTH);
        totalPower += worldIn.func_180495_p(pos.func_177974_f()).func_185911_a((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.EAST);
        BlockPos newp = pos.func_177979_c(totalPower += worldIn.func_180495_p(pos.func_177976_e()).func_185911_a((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.WEST));
        if (newp.func_177956_o() < 5 || worldIn.func_180495_p(newp).func_177230_c() == Blocks.field_150357_h) {
            totalPower -= 5 - newp.func_177956_o();
        }
        if (worldIn.func_180495_p(newp).func_177230_c() == ModBlocks.GEM_SEED) {
            totalPower += 256;
        }
        return pos.func_177956_o() - totalPower;
    }

    public int calcDistanceAutomatically(World worldIn, BlockPos pos) {
        int bestDepth = -1;
        int worstDepth = 5;
        for (bestDepth = pos.func_177979_c(6).func_177956_o(); bestDepth > worstDepth; --bestDepth) {
            BlockPos temp;
            boolean aerated = false;
            BlockPos newBlockPos = new BlockPos(pos.func_177958_n(), bestDepth, pos.func_177952_p());
            if (worldIn.func_180495_p(newBlockPos).func_177230_c() == ModBlocks.GEM_SEED || worldIn.func_180495_p(newBlockPos).func_177230_c() == Blocks.field_150357_h || !worldIn.isSideSolid(newBlockPos, EnumFacing.UP) || !worldIn.isSideSolid(newBlockPos.func_177984_a(), EnumFacing.DOWN)) {
                bestDepth -= 3;
                continue;
            }
            boolean inContactWithAir = false;
            for (int x = -9; x <= 9; ++x) {
                temp = new BlockPos(newBlockPos.func_177958_n() + x, bestDepth, newBlockPos.func_177952_p());
                if (Math.abs(x) > 1) {
                    if (!worldIn.func_175623_d(temp) || !worldIn.func_175678_i(temp) && !((double)worldIn.func_175699_k(newBlockPos) > 0.9)) continue;
                    aerated = true;
                    continue;
                }
                if (x == 0) continue;
                inContactWithAir = worldIn.func_175623_d(temp);
            }
            for (int z = -9; z <= 9; ++z) {
                temp = new BlockPos(newBlockPos.func_177958_n(), bestDepth, newBlockPos.func_177952_p() + z);
                if (Math.abs(z) > 1) {
                    if (!worldIn.func_175623_d(temp) || !worldIn.func_175678_i(temp) && !((double)worldIn.func_175699_k(newBlockPos) > 0.9)) continue;
                    aerated = true;
                    continue;
                }
                if (z == 0) continue;
                inContactWithAir = worldIn.func_175623_d(temp);
            }
            if (!aerated || inContactWithAir) continue;
            return bestDepth;
        }
        return bestDepth;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K && this.isEquipped && worldIn.func_180495_p(pos).func_177230_c() != ModBlocks.INJECTOR) {
            EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Item)ModItems.ACTIVATED_GEM_BASE));
            worldIn.func_72838_d((Entity)item);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.INJECTOR);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.INJECTOR);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        worldIn.func_180501_a(pos, ModBlocks.INJECTOR.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
        worldIn.func_180501_a(pos, ModBlocks.INJECTOR.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

