/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpawnerManager
extends JSONLoader {
    public static SpawnerManager INSTANCE;
    public Map<String, Spawner> spawners = new HashMap<String, Spawner>();
    public List<SpawnCondition> globalSpawnConditions = new ArrayList<SpawnCondition>();

    public static SpawnerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpawnerManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJson(ModInfo modInfo) {
        JsonObject globalJson;
        JsonObject defaultGlobalJson;
        this.loadAllJson(modInfo, "Spawner", "spawners", "name", true, "spawner", FileLoader.SERVER, StreamLoader.SERVER);
        LycanitesMobs.logDebug("Spawner", "Complete! " + this.spawners.size() + " JSON Spawners Loaded In Total.");
        this.loadAllJson(modInfo, "Spawner", "mobevents", "name", true, "spawner", FileLoader.COMMON, StreamLoader.COMMON);
        LycanitesMobs.logDebug("Spawner", "Complete! " + this.spawners.size() + " JSON Spawners Loaded In Total.");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String configPath = new File(".") + "/config/" + "lycanitesmobs" + "/";
        this.globalSpawnConditions.clear();
        if (FileLoader.SERVER.ready) {
            Path defaultGlobalPath = FileLoader.SERVER.getPath("globalspawner.json");
            LycanitesMobs.logDebug("", "Global Spawner JSON Path:" + defaultGlobalPath);
            defaultGlobalJson = this.loadJsonObject(gson, defaultGlobalPath);
        } else {
            defaultGlobalJson = this.loadJsonObject(gson, StreamLoader.SERVER.getStream("globalspawner.json"));
        }
        if (defaultGlobalJson == null) {
            LycanitesMobs.logWarning("", "Could not find Global Spawning JSON.");
        }
        File customGlobalFile = new File(configPath + "globalspawner.json");
        JsonObject customGlobalJson = null;
        if (customGlobalFile.exists()) {
            customGlobalJson = this.loadJsonObject(gson, customGlobalFile.toPath());
        }
        if ((globalJson = this.writeDefaultJSONObject(gson, "globalspawner", defaultGlobalJson, customGlobalJson)).has("conditions")) {
            JsonArray jsonArray = globalJson.get("conditions").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject spawnConditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(spawnConditionJson);
                this.globalSpawnConditions.add(spawnCondition);
            }
        }
        if (this.globalSpawnConditions.size() > 0) {
            LycanitesMobs.logDebug("JSONSpawner", "Loaded " + this.globalSpawnConditions.size() + " Global Spawn Conditions.");
        }
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        LycanitesMobs.logDebug("JSONSpawner", "Loading Spawner JSON: " + json);
        Spawner spawner = new Spawner();
        spawner.loadFromJSON(json);
        this.addSpawner(spawner);
    }

    public void reload() {
        LycanitesMobs.logDebug("JSONSpawner", "Destroying JSON Spawners!");
        for (Spawner spawner : this.spawners.values().toArray(new Spawner[this.spawners.size()])) {
            spawner.destroy();
        }
        this.loadAllFromJson(LycanitesMobs.modInfo);
    }

    public void addSpawner(Spawner spawner) {
        if (this.spawners.containsKey(spawner.name)) {
            LycanitesMobs.logWarning("", "[Spawner Manager] Tried to add a Spawner with a name that is already in use: " + spawner.name);
            return;
        }
        if (this.spawners.values().contains(spawner)) {
            LycanitesMobs.logWarning("", "[Spawner Manager] Tried to add a Spawner that is already added: " + spawner.name);
            return;
        }
        this.spawners.put(spawner.name, spawner);
    }

    public void removeSpawner(Spawner spawner) {
        if (!this.spawners.containsKey(spawner.name)) {
            LycanitesMobs.logWarning("", "[Spawner Manager] Tried to remove a Spawner that hasn't been added: " + spawner.name);
            return;
        }
        this.spawners.remove(spawner.name);
    }
}

