/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.PetEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class PetManager {
    public LivingEntity host;
    protected int nextID = 0;
    public Map<Integer, PetEntry> allEntries = new HashMap<Integer, PetEntry>();
    public List<PetEntry> pets = new ArrayList<PetEntry>();
    public List<PetEntry> mounts = new ArrayList<PetEntry>();
    public List<PetEntry> minions = new ArrayList<PetEntry>();
    public List<PetEntry> guardians = new ArrayList<PetEntry>();
    public List<PetEntry> familiars = new ArrayList<PetEntry>();
    public List<PetEntry> newEntries = new ArrayList<PetEntry>();
    public List<PetEntry> removedEntries = new ArrayList<PetEntry>();
    public Map<String, CompoundNBT> entryNBTs = new HashMap<String, CompoundNBT>();

    public PetManager(LivingEntity host) {
        this.host = host;
    }

    public boolean hasEntry(PetEntry petEntry) {
        return this.allEntries.containsValue(petEntry);
    }

    public void addEntry(PetEntry petEntry) {
        this.addEntry(petEntry, -1);
    }

    public void addEntry(PetEntry petEntry, int entryID) {
        if (this.allEntries.containsValue(petEntry)) {
            LycanitesMobs.logWarning("", "[Pet Manager] Tried to add a Pet Entry that is already added!");
            return;
        }
        if (this.entryNBTs.containsKey(petEntry.name)) {
            petEntry.readFromNBT(this.entryNBTs.get(petEntry.name));
        }
        if (entryID < 0) {
            entryID = this.nextID++;
        } else if (entryID >= this.nextID) {
            this.nextID = entryID + 1;
        }
        this.allEntries.put(entryID, petEntry);
        if ("pet".equalsIgnoreCase(petEntry.getType())) {
            this.pets.add(petEntry);
        } else if ("mount".equalsIgnoreCase(petEntry.getType())) {
            this.mounts.add(petEntry);
        } else if ("minion".equalsIgnoreCase(petEntry.getType())) {
            this.minions.add(petEntry);
        } else if ("guardian".equalsIgnoreCase(petEntry.getType())) {
            this.guardians.add(petEntry);
        } else if ("familiar".equalsIgnoreCase(petEntry.getType())) {
            this.familiars.add(petEntry);
        }
        petEntry.onAdd(this, entryID);
        this.newEntries.add(petEntry);
    }

    public void removeEntry(PetEntry petEntry) {
        if (!this.allEntries.containsValue(petEntry)) {
            LycanitesMobs.logWarning("", "[Pet Manager] Tried to remove a pet entry that isn't added!");
            return;
        }
        this.allEntries.remove(petEntry.petEntryID);
        if ("pet".equalsIgnoreCase(petEntry.getType())) {
            this.pets.remove(petEntry);
        } else if ("mount".equalsIgnoreCase(petEntry.getType())) {
            this.mounts.remove(petEntry);
        } else if ("minion".equalsIgnoreCase(petEntry.getType())) {
            this.minions.remove(petEntry);
        } else if ("guardian".equalsIgnoreCase(petEntry.getType())) {
            this.guardians.remove(petEntry);
        } else if ("familiar".equalsIgnoreCase(petEntry.getType())) {
            this.familiars.remove(petEntry);
        }
    }

    public void clearEntries(String type) {
        if ("pet".equalsIgnoreCase(type)) {
            for (PetEntry petEntry : this.pets) {
                this.allEntries.remove(petEntry.petEntryID);
            }
            this.pets = new ArrayList<PetEntry>();
        } else if ("mount".equalsIgnoreCase(type)) {
            for (PetEntry petEntry : this.mounts) {
                this.allEntries.remove(petEntry.petEntryID);
            }
            this.mounts = new ArrayList<PetEntry>();
        } else if ("minion".equalsIgnoreCase(type)) {
            for (PetEntry petEntry : this.minions) {
                this.allEntries.remove(petEntry.petEntryID);
            }
            this.minions = new ArrayList<PetEntry>();
        } else if ("guardian".equalsIgnoreCase(type)) {
            for (PetEntry petEntry : this.guardians) {
                this.allEntries.remove(petEntry.petEntryID);
            }
            this.guardians = new ArrayList<PetEntry>();
        } else if ("familiar".equalsIgnoreCase(type)) {
            for (PetEntry petEntry : this.familiars) {
                this.allEntries.remove(petEntry.petEntryID);
            }
            this.familiars = new ArrayList<PetEntry>();
        }
    }

    public void onUpdate(World world) {
        ExtendedPlayer extendedPlayer;
        if (this.newEntries.size() > 0) {
            if (!world.field_72995_K && this.host instanceof PlayerEntity) {
                for (PetEntry petEntry : this.newEntries) {
                    ExtendedPlayer playerExt2 = ExtendedPlayer.getForPlayer((PlayerEntity)this.host);
                    if (playerExt2 == null) continue;
                    playerExt2.sendPetEntryToPlayer(petEntry);
                }
            }
            this.newEntries = new ArrayList<PetEntry>();
        }
        int newSpiritReserved = 0;
        for (PetEntry petEntry : this.allEntries.values()) {
            ExtendedPlayer playerExt3;
            if (petEntry.host != this.host) {
                petEntry.setOwner(this.host);
            }
            if (this.host instanceof PlayerEntity && (playerExt3 = ExtendedPlayer.getForPlayer((PlayerEntity)this.host)) != null && petEntry.usesSpirit()) {
                int spiritCost = petEntry.getSpiritCost();
                if (petEntry.spawningActive && petEntry.active && (playerExt3.spirit + playerExt3.spiritReserved < (newSpiritReserved += spiritCost) || newSpiritReserved > playerExt3.spiritMax)) {
                    petEntry.spawningActive = false;
                    newSpiritReserved -= spiritCost;
                }
            }
            if (petEntry.active) {
                petEntry.onUpdate(world);
                continue;
            }
            this.removedEntries.add(petEntry);
        }
        if (this.removedEntries.size() > 0) {
            for (PetEntry petEntry : this.removedEntries) {
                this.removeEntry(petEntry);
            }
            this.removedEntries = new ArrayList<PetEntry>();
        }
        if (this.host instanceof PlayerEntity && (extendedPlayer = ExtendedPlayer.getForPlayer((PlayerEntity)this.host)) != null) {
            extendedPlayer.spiritReserved = newSpiritReserved;
        }
    }

    public PetEntry getEntry(int id) {
        return this.allEntries.get(id);
    }

    public PetEntry getEntry(String type, int id) {
        return this.getEntryList(type).get(id);
    }

    public List<PetEntry> getEntryList(String type) {
        if ("pet".equalsIgnoreCase(type)) {
            return this.pets;
        }
        if ("mount".equalsIgnoreCase(type)) {
            return this.mounts;
        }
        if ("minion".equalsIgnoreCase(type)) {
            return this.minions;
        }
        if ("guardian".equalsIgnoreCase(type)) {
            return this.guardians;
        }
        if ("familiar".equalsIgnoreCase(type)) {
            return this.familiars;
        }
        return null;
    }

    public void readFromNBT(CompoundNBT nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("PetManager")) {
            return;
        }
        this.entryNBTs = new HashMap<String, CompoundNBT>();
        ListNBT entryList = nbtTagCompound.func_150295_c("PetManager", 10);
        for (int i = 0; i < entryList.size(); ++i) {
            CompoundNBT nbtEntry = (CompoundNBT)entryList.get(i);
            if (!nbtEntry.func_74764_b("EntryName")) continue;
            this.entryNBTs.put(nbtEntry.func_74779_i("EntryName"), nbtEntry);
        }
        for (PetEntry petEntry : this.allEntries.values()) {
            if (!this.entryNBTs.containsKey(petEntry.name)) continue;
            petEntry.readFromNBT(this.entryNBTs.get(petEntry.name));
            this.entryNBTs.remove(petEntry.name);
        }
        for (CompoundNBT nbtEntry : this.entryNBTs.values()) {
            if (!nbtEntry.func_74764_b("Type") || !"pet".equalsIgnoreCase(nbtEntry.func_74779_i("Type")) && !"mount".equalsIgnoreCase(nbtEntry.func_74779_i("Type"))) continue;
            PetEntry petEntry = new PetEntry(nbtEntry.func_74779_i("EntryName"), nbtEntry.func_74779_i("Type"), this.host, nbtEntry.func_74779_i("SummonType"));
            petEntry.readFromNBT(nbtEntry);
            if (!petEntry.active) continue;
            this.addEntry(petEntry);
        }
    }

    public void writeToNBT(CompoundNBT nbtTagCompound) {
        ArrayList<String> writtenEntries = new ArrayList<String>();
        ListNBT entryList = new ListNBT();
        for (PetEntry petEntry : this.allEntries.values()) {
            if (!petEntry.active) continue;
            CompoundNBT nbtEntry = new CompoundNBT();
            petEntry.writeToNBT(nbtEntry);
            entryList.add((Object)nbtEntry);
            writtenEntries.add(petEntry.name);
        }
        nbtTagCompound.func_218657_a("PetManager", (INBT)entryList);
    }
}

