/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PetEntry {
    public String name;
    public PetManager petManager;
    public int petEntryID;
    private String type;
    public boolean active = true;
    public int respawnTime = 0;
    public int respawnTimeMax;
    public boolean isRespawning = false;
    public int spawnCount = 0;
    public boolean temporary = false;
    public int temporaryDuration = 100;
    public boolean spawningActive = true;
    public LivingEntity host;
    public SummonSet summonSet;
    public Entity entity;
    public CompoundNBT entityNBT;
    public int entityTick = 0;
    public float entityHealth = 1.0f;
    public float entityMaxHealth = 1.0f;
    public String entityName = "";
    public int subspeciesID = 0;
    public double entitySize = 1.0;
    public String color = "000000";
    public boolean teleportEntity = false;
    public boolean releaseEntity = false;

    public static PetEntry createFromEntity(PlayerEntity player, BaseCreatureEntity entity, String petType) {
        CreatureInfo creatureInfo = entity.creatureInfo;
        String entryName = petType + "-" + player.func_200200_C_() + "-" + creatureInfo.getName() + "-" + UUID.randomUUID().toString();
        PetEntry petEntry = new PetEntry(entryName, petType, (LivingEntity)player, creatureInfo.getName());
        if (entity.func_145818_k_()) {
            petEntry.setEntityName(entity.func_200201_e().toString());
        }
        petEntry.setEntitySubspeciesID(entity.getSubspeciesIndex());
        petEntry.setEntitySize(entity.sizeScale);
        petEntry.setColor("000000");
        return petEntry;
    }

    public PetEntry(String name, String type, LivingEntity host, String summonType) {
        this.name = name;
        this.type = type;
        this.host = host;
        ExtendedPlayer playerExt = null;
        if (host != null && host instanceof PlayerEntity) {
            playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)host);
        }
        this.summonSet = new SummonSet(playerExt);
        this.summonSet.summonableOnly = false;
        this.summonSet.setSummonType(summonType);
        this.respawnTimeMax = 6000;
        if ("minion".equalsIgnoreCase(this.type)) {
            this.temporary = true;
        }
    }

    public PetEntry setEntityName(String name) {
        this.entityName = name;
        return this;
    }

    public PetEntry setEntitySubspeciesID(int id) {
        this.subspeciesID = id;
        return this;
    }

    public PetEntry setEntitySize(double size) {
        this.entitySize = size;
        return this;
    }

    public PetEntry setColor(String color) {
        this.color = color;
        return this;
    }

    public PetEntry setOwner(LivingEntity owner) {
        this.host = owner;
        if (this.host != null && this.host instanceof PlayerEntity) {
            ExtendedPlayer playerExt;
            this.summonSet.playerExt = playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)this.host);
        }
        return this;
    }

    public PetEntry setSpawningActive(boolean spawningActive) {
        if (this.spawningActive == spawningActive) {
            return this;
        }
        if (!this.host.func_130014_f_().field_72995_K) {
            if (!spawningActive) {
                this.despawnEntity();
            } else if (this.usesSpirit() && this.summonSet.playerExt != null) {
                if (this.summonSet.playerExt.spirit < this.getSpiritCost()) {
                    this.spawningActive = false;
                    return this;
                }
                this.summonSet.playerExt.spirit -= this.getSpiritCost();
                this.summonSet.playerExt.spiritReserved += this.getSpiritCost();
            }
        }
        this.spawningActive = spawningActive;
        return this;
    }

    public CreatureInfo getCreatureInfo() {
        if (this.summonSet == null || "".equals(this.summonSet.summonType)) {
            return null;
        }
        return CreatureManager.getInstance().getCreature(this.summonSet.summonType);
    }

    public float getHealth() {
        if (this.entity != null && this.entity instanceof LivingEntity) {
            this.entityHealth = ((LivingEntity)this.entity).func_110143_aJ();
        }
        return this.entityHealth;
    }

    public float getMaxHealth() {
        if (this.entity != null && this.entity instanceof LivingEntity) {
            this.entityMaxHealth = ((LivingEntity)this.entity).func_110138_aP();
        }
        return this.entityMaxHealth;
    }

    public void copy(PetEntry copyEntry) {
        this.setEntityName(copyEntry.entityName);
        this.setEntitySubspeciesID(copyEntry.subspeciesID);
        this.setEntitySize(copyEntry.entitySize);
        this.setColor(copyEntry.color);
        if (copyEntry.summonSet != null) {
            this.summonSet.setSummonType(copyEntry.summonSet.summonType);
        }
    }

    public String getName() {
        return this.name;
    }

    public ITextComponent getDisplayName() {
        ITextComponent displayName = this.summonSet.getCreatureInfo().getTitle();
        if (this.entityName != null && !"".equals(this.entityName)) {
            displayName = new StringTextComponent(this.entityName + " (").func_150257_a(displayName).func_150258_a(")");
        }
        return displayName;
    }

    public void onAdd(PetManager petManager, int petEntryID) {
        this.petManager = petManager;
        this.petEntryID = petEntryID;
    }

    public void remove() {
        this.setSpawningActive(false);
        this.active = false;
    }

    public void onUpdate(World world) {
        if (world.field_72995_K) {
            if (this.isRespawning && this.respawnTime > 0) {
                --this.respawnTime;
            }
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.isActive()) {
            this.remove();
            return;
        }
        if (this.spawningActive) {
            if (this.entity != null && !this.entity.func_70089_S()) {
                this.saveEntityNBT();
                this.entity = null;
                this.isRespawning = true;
                this.respawnTime = this.respawnTimeMax;
                if (this.summonSet.playerExt != null) {
                    this.summonSet.playerExt.sendPetEntryToPlayer(this);
                }
            }
            if (this.entity == null) {
                if (!this.isRespawning) {
                    this.respawnTime = 0;
                }
                if (this.respawnTime-- <= 0) {
                    this.spawnEntity();
                    this.isRespawning = false;
                }
            }
            if (this.entity != null) {
                ++this.entityTick;
                try {
                    if (this.teleportEntity) {
                        if (this.entity.func_130014_f_() != this.host.func_130014_f_()) {
                            this.entity.func_212321_a(this.host.func_130014_f_().func_201675_m().func_186058_p());
                        }
                        this.entity.func_70107_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v);
                    }
                }
                catch (Exception e) {
                    LycanitesMobs.logDebug("Pet", "Unable to teleport a pet.");
                }
                if (this.entity instanceof LivingEntity) {
                    LivingEntity entityLiving = (LivingEntity)this.entity;
                    if (this.entityTick % 20 == 0 && entityLiving.func_110143_aJ() < entityLiving.func_110138_aP()) {
                        entityLiving.func_70606_j(Math.min(entityLiving.func_110143_aJ() + 1.0f, entityLiving.func_110138_aP()));
                    }
                    this.entityHealth = entityLiving.func_110143_aJ();
                    this.entityMaxHealth = entityLiving.func_110138_aP();
                }
                if (this.entity.func_145818_k_()) {
                    this.entityName = this.entity.func_200201_e().toString();
                }
            }
        } else {
            if (this.entity != null) {
                this.saveEntityNBT();
                this.entity.func_70106_y();
                this.entity = null;
            }
            if (this.respawnTime > 0) {
                --this.respawnTime;
            }
        }
        this.teleportEntity = false;
    }

    public void onBehaviourUpdate() {
        if (this.entity != null && this.entity instanceof TameableCreatureEntity) {
            this.summonSet.applyBehaviour((TameableCreatureEntity)this.entity);
        }
    }

    public boolean isActive() {
        return this.entity != null || !this.temporary || this.spawnCount <= 0;
    }

    public void spawnEntity() {
        if (this.entity != null || this.host == null) {
            return;
        }
        try {
            this.entity = this.summonSet.getCreatureType().func_200721_a(this.host.func_130014_f_());
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Pets", "[Pet Entry] Unable to find an entity class for pet entry.  Type: " + this.summonSet.summonType + " Class: " + this.summonSet.getCreatureType() + " Name: " + this.name);
        }
        if (this.entity == null) {
            return;
        }
        this.loadEntityNBT();
        this.entity.func_70012_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, this.host.field_70177_z, 0.0f);
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)this.entity;
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof TameableCreatureEntity) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                this.summonSet.applyBehaviour(entityTameable);
            }
            float randomAngle = 45.0f + 45.0f * this.host.func_70681_au().nextFloat();
            if (this.host.func_70681_au().nextBoolean()) {
                randomAngle = -randomAngle;
            }
            BlockPos spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, randomAngle);
            if (this.entity.func_130014_f_().func_180495_p(spawnPos).func_215688_a((IBlockReader)this.entity.func_130014_f_(), spawnPos, this.entity.func_200600_R())) {
                this.entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
            } else {
                spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, -randomAngle);
                if (this.entity.func_130014_f_().func_180495_p(spawnPos).func_215688_a((IBlockReader)this.entity.func_130014_f_(), spawnPos, this.entity.func_200600_R())) {
                    this.entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
                }
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent(this.entityName, new Object[0]));
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.applySubspecies(this.subspeciesID);
            if (entityCreature instanceof TameableCreatureEntity && this.host instanceof PlayerEntity) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                entityTameable.setPlayerOwner((PlayerEntity)this.host);
                this.summonSet.applyBehaviour(entityTameable);
            }
        }
        ++this.spawnCount;
        if (this.entity instanceof LivingEntity && this.isRespawning) {
            LivingEntity entityLiving = (LivingEntity)this.entity;
            entityLiving.func_70606_j(entityLiving.func_110138_aP() / 2.0f);
        }
        this.onSpawnEntity(this.entity);
        this.host.func_130014_f_().func_217376_c(this.entity);
    }

    public void onSpawnEntity(Entity entity) {
    }

    public void despawnEntity() {
        if (this.entity == null) {
            return;
        }
        this.onDespawnEntity(this.entity);
        this.saveEntityNBT();
        this.entity.func_70106_y();
        this.entity = null;
    }

    public void onDespawnEntity(Entity entity) {
    }

    public void assignEntity(Entity entity) {
        if (this.entity != null) {
            this.despawnEntity();
        }
        this.setSpawningActive(true);
        this.entity = entity;
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)this.entity;
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof TameableCreatureEntity) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                this.summonSet.updateBehaviour(entityTameable);
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_200203_b((ITextComponent)new TranslationTextComponent(this.entityName, new Object[0]));
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.applySubspecies(this.subspeciesID);
        }
        ++this.spawnCount;
        this.saveEntityNBT();
        this.onSpawnEntity(this.entity);
    }

    public String getType() {
        return this.type;
    }

    public boolean usesSpirit() {
        return "pet".equals(this.getType()) || "mount".equals(this.getType());
    }

    public int getSpiritCost() {
        if (this.summonSet.playerExt == null) {
            return 0;
        }
        return this.summonSet.playerExt.spiritCharge * this.getCreatureInfo().summonCost;
    }

    public void readFromNBT(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("Active")) {
            this.active = nbtTagCompound.func_74767_n("Active");
        }
        if (nbtTagCompound.func_74764_b("RespawnTime")) {
            this.respawnTime = nbtTagCompound.func_74762_e("RespawnTime");
        }
        if (nbtTagCompound.func_74764_b("Respawning")) {
            this.isRespawning = nbtTagCompound.func_74767_n("Respawning");
        }
        if (nbtTagCompound.func_74764_b("SpawningActive")) {
            this.spawningActive = nbtTagCompound.func_74767_n("SpawningActive");
        }
        this.summonSet.read(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("EntityName")) {
            this.setEntityName(nbtTagCompound.func_74779_i("EntityName"));
        }
        if (nbtTagCompound.func_74764_b("SubspeciesID")) {
            this.setEntitySubspeciesID(nbtTagCompound.func_74762_e("SubspeciesID"));
        }
        if (nbtTagCompound.func_74764_b("EntitySize")) {
            this.setEntitySize(nbtTagCompound.func_74769_h("EntitySize"));
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(nbtTagCompound.func_74779_i("Color"));
        }
        if (nbtTagCompound.func_74764_b("EntityNBT")) {
            this.entityNBT = nbtTagCompound.func_74775_l("EntityNBT");
        }
    }

    public void writeToNBT(CompoundNBT nbtTagCompound) {
        if (this.name == null || "".equals(this.name)) {
            return;
        }
        nbtTagCompound.func_74757_a("Active", this.active);
        nbtTagCompound.func_74768_a("RespawnTime", this.respawnTime);
        nbtTagCompound.func_74757_a("Respawning", this.isRespawning);
        nbtTagCompound.func_74757_a("SpawningActive", this.spawningActive);
        nbtTagCompound.func_74768_a("ID", this.petEntryID);
        nbtTagCompound.func_74778_a("EntryName", this.name);
        nbtTagCompound.func_74778_a("Type", this.getType());
        this.summonSet.write(nbtTagCompound);
        if (this.usesSpirit()) {
            this.saveEntityNBT();
            nbtTagCompound.func_74778_a("EntityName", this.entityName);
            nbtTagCompound.func_74768_a("SubspeciesID", this.subspeciesID);
            nbtTagCompound.func_74780_a("EntitySize", this.entitySize);
            nbtTagCompound.func_74778_a("Color", this.color);
            nbtTagCompound.func_218657_a("EntityNBT", (INBT)this.entityNBT);
        }
    }

    public void saveEntityNBT() {
        if (this.entity == null) {
            return;
        }
        if (this.entityNBT == null) {
            this.entityNBT = new CompoundNBT();
        }
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)this.entity;
            baseCreatureEntity.inventory.write(this.entityNBT);
            CompoundNBT extTagCompound = new CompoundNBT();
            baseCreatureEntity.extraMobBehaviour.write(extTagCompound);
            this.entityNBT.func_218657_a("ExtraBehaviour", (INBT)extTagCompound);
            if (this.entity instanceof AgeableCreatureEntity) {
                AgeableCreatureEntity ageableCreatureEntity = (AgeableCreatureEntity)this.entity;
                this.entityNBT.func_74768_a("Age", ageableCreatureEntity.getGrowingAge());
            }
        }
        if (this.entity instanceof BaseCreatureEntity && this.entity.func_145818_k_()) {
            this.entityName = this.entity.func_200201_e().toString();
        }
        this.entity.func_189511_e(this.entityNBT);
    }

    public void loadEntityNBT() {
        if (this.entity == null || this.entityNBT == null) {
            return;
        }
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)this.entity;
            baseCreatureEntity.inventory.read(this.entityNBT);
            if (this.entityNBT.func_74764_b("ExtraBehaviour")) {
                baseCreatureEntity.extraMobBehaviour.read(this.entityNBT.func_74775_l("ExtraBehaviour"));
            }
            if (this.entity instanceof AgeableCreatureEntity) {
                AgeableCreatureEntity ageableCreatureEntity = (AgeableCreatureEntity)this.entity;
                if (this.entityNBT.func_74764_b("Age")) {
                    ageableCreatureEntity.setGrowingAge(this.entityNBT.func_74762_e("Age"));
                } else {
                    ageableCreatureEntity.setGrowingAge(0);
                }
            }
        }
    }
}

