/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSummoningPedestalStats {
    public int capacity;
    public int progress;
    public int fuel;
    public int fuelMax;
    public int x;
    public int y;
    public int z;

    public MessageSummoningPedestalStats() {
    }

    public MessageSummoningPedestalStats(int capacity, int progress, int fuel, int fuelMax, int x, int y, int z) {
        this.capacity = capacity;
        this.progress = progress;
        this.fuel = fuel;
        this.fuelMax = fuelMax;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void handle(MessageSummoningPedestalStats message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        TileEntity tileEntity = player.func_130014_f_().func_175625_s(new BlockPos(message.x, message.y, message.z));
        TileEntitySummoningPedestal summoningPedestal = null;
        if (tileEntity instanceof TileEntitySummoningPedestal) {
            summoningPedestal = (TileEntitySummoningPedestal)tileEntity;
        }
        if (summoningPedestal == null) {
            return;
        }
        summoningPedestal.capacity = message.capacity;
        summoningPedestal.summonProgress = message.progress;
        summoningPedestal.summoningFuel = message.fuel;
        summoningPedestal.summoningFuelMax = message.fuelMax;
    }

    public static MessageSummoningPedestalStats decode(PacketBuffer packet) {
        MessageSummoningPedestalStats message = new MessageSummoningPedestalStats();
        message.x = packet.readInt();
        message.y = packet.readInt();
        message.z = packet.readInt();
        message.capacity = packet.readInt();
        message.progress = packet.readInt();
        message.fuel = packet.readInt();
        message.fuelMax = packet.readInt();
        return message;
    }

    public static void encode(MessageSummoningPedestalStats message, PacketBuffer packet) {
        packet.writeInt(message.x);
        packet.writeInt(message.y);
        packet.writeInt(message.z);
        packet.writeInt(message.capacity);
        packet.writeInt(message.progress);
        packet.writeInt(message.fuel);
        packet.writeInt(message.fuelMax);
    }
}

