/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerStats {
    public int spirit;
    public int summonFocus;

    public MessagePlayerStats() {
    }

    public MessagePlayerStats(ExtendedPlayer playerExt) {
        this.spirit = playerExt.spirit;
        this.summonFocus = playerExt.summonFocus;
    }

    public static void handle(MessagePlayerStats message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        playerExt.spirit = message.spirit;
        playerExt.summonFocus = message.summonFocus;
    }

    public static MessagePlayerStats decode(PacketBuffer packet) {
        MessagePlayerStats message = new MessagePlayerStats();
        message.spirit = packet.readInt();
        message.summonFocus = packet.readInt();
        return message;
    }

    public static void encode(MessagePlayerStats message, PacketBuffer packet) {
        packet.writeInt(message.spirit);
        packet.writeInt(message.summonFocus);
    }
}

