/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.entity.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePlayerControl {
    public byte controlStates;

    public MessagePlayerControl() {
    }

    public MessagePlayerControl(byte controlStates) {
        this.controlStates = controlStates;
    }

    public static void handle(MessagePlayerControl message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
            playerExt.updateControlStates(message.controlStates);
        });
    }

    public static MessagePlayerControl decode(PacketBuffer packet) {
        MessagePlayerControl message = new MessagePlayerControl();
        message.controlStates = packet.readByte();
        return message;
    }

    public static void encode(MessagePlayerControl message, PacketBuffer packet) {
        packet.writeByte((int)message.controlStates);
    }
}

