/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePetEntry {
    public String petEntryName;
    public int petEntryID;
    public String petEntryType;
    public boolean spawningActive;
    public boolean teleportEntity;
    public String summonType;
    public int subspecies;
    public byte behaviour;
    public int petEntryEntityID;
    public String petEntryEntityName;
    public int respawnTime;
    public int respawnTimeMax;
    public boolean isRespawning;

    public MessagePetEntry() {
    }

    public MessagePetEntry(ExtendedPlayer playerExt, PetEntry petEntry) {
        this.petEntryName = petEntry.name != null ? petEntry.name : "";
        this.petEntryID = petEntry.petEntryID;
        this.petEntryType = petEntry.getType();
        this.spawningActive = petEntry.spawningActive;
        this.teleportEntity = petEntry.teleportEntity;
        SummonSet summonSet = petEntry.summonSet;
        this.summonType = summonSet.summonType;
        this.subspecies = petEntry.subspeciesID;
        this.behaviour = summonSet.getBehaviourByte();
        this.petEntryEntityID = petEntry.entity != null ? petEntry.entity.func_145782_y() : 0;
        this.petEntryEntityName = petEntry.entityName;
        this.respawnTime = petEntry.respawnTime;
        this.respawnTimeMax = petEntry.respawnTimeMax;
        this.isRespawning = petEntry.isRespawning;
    }

    public static void handle(MessagePetEntry message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer((PlayerEntity)player);
                PetManager petManager = playerExt.petManager;
                PetEntry petEntry = petManager.getEntry(message.petEntryID);
                if (petEntry == null) {
                    return;
                }
                petEntry.setSpawningActive(message.spawningActive);
                petEntry.teleportEntity = message.teleportEntity;
                SummonSet summonSet = petEntry.summonSet;
                summonSet.readFromPacket(message.summonType, 0, message.behaviour);
                petEntry.onBehaviourUpdate();
            });
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        PetManager petManager = playerExt.petManager;
        PetEntry petEntry = petManager.getEntry(message.petEntryID);
        if (petEntry == null) {
            petEntry = new PetEntry(message.petEntryName, message.petEntryType, (LivingEntity)player, message.summonType);
            petManager.addEntry(petEntry, message.petEntryID);
        }
        petEntry.setSpawningActive(message.spawningActive);
        petEntry.teleportEntity = message.teleportEntity;
        petEntry.subspeciesID = message.subspecies;
        SummonSet summonSet = petEntry.summonSet;
        summonSet.readFromPacket(message.summonType, 0, message.behaviour);
        Entity entity = null;
        if (message.petEntryEntityID != 0) {
            entity = player.func_130014_f_().func_73045_a(message.petEntryEntityID);
        }
        petEntry.entity = entity;
        petEntry.entityName = message.petEntryEntityName;
        petEntry.respawnTime = message.respawnTime;
        petEntry.respawnTimeMax = message.respawnTimeMax;
        petEntry.isRespawning = message.isRespawning;
    }

    public static MessagePetEntry decode(PacketBuffer packet) {
        MessagePetEntry message = new MessagePetEntry();
        message.petEntryName = packet.func_150789_c(256);
        message.petEntryID = packet.readInt();
        message.petEntryType = packet.func_150789_c(256);
        message.spawningActive = packet.readBoolean();
        message.teleportEntity = packet.readBoolean();
        message.summonType = packet.func_150789_c(256);
        message.subspecies = packet.readInt();
        message.behaviour = packet.readByte();
        message.petEntryEntityID = packet.readInt();
        message.petEntryEntityName = packet.func_150789_c(1024);
        message.respawnTime = packet.readInt();
        message.respawnTimeMax = packet.readInt();
        message.isRespawning = packet.readBoolean();
        return message;
    }

    public static void encode(MessagePetEntry message, PacketBuffer packet) {
        packet.func_180714_a(message.petEntryName);
        packet.writeInt(message.petEntryID);
        packet.func_180714_a(message.petEntryType);
        packet.writeBoolean(message.spawningActive);
        packet.writeBoolean(message.teleportEntity);
        packet.func_180714_a(message.summonType);
        packet.writeInt(message.subspecies);
        packet.writeByte((int)message.behaviour);
        packet.writeInt(message.petEntryEntityID);
        packet.func_180714_a(message.petEntryEntityName);
        packet.writeInt(message.respawnTime);
        packet.writeInt(message.respawnTimeMax);
        packet.writeBoolean(message.isRespawning);
    }
}

