/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.ExtendedWorld;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageMobEvent {
    public String mobEventName;
    public BlockPos pos;
    public int level = 1;

    public MessageMobEvent() {
    }

    public MessageMobEvent(String mobEventName, BlockPos pos, int level) {
        this.mobEventName = mobEventName;
        this.pos = pos;
        this.level = level;
    }

    public static void handle(MessageMobEvent message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = ClientManager.getInstance().getClientPlayer();
            World world = player.func_130014_f_();
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
            if ("".equals(message.mobEventName)) {
                worldExt.stopMobEvent(message.mobEventName);
            } else {
                worldExt.startMobEvent(message.mobEventName, null, message.pos, message.level);
            }
        });
    }

    public static MessageMobEvent decode(PacketBuffer packet) {
        MessageMobEvent message = new MessageMobEvent();
        message.mobEventName = packet.func_150789_c(256);
        message.pos = packet.func_179259_c();
        message.level = packet.readInt();
        return message;
    }

    public static void encode(MessageMobEvent message, PacketBuffer packet) {
        packet.func_180714_a(message.mobEventName);
        packet.func_179255_a(message.pos);
        packet.writeInt(message.level);
    }
}

