/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCreatureKnowledge {
    public String creatureName;
    public int rank;

    public MessageCreatureKnowledge() {
    }

    public MessageCreatureKnowledge(CreatureKnowledge creatureKnowledge) {
        this.creatureName = creatureKnowledge.creatureName;
        this.rank = creatureKnowledge.rank;
    }

    public static void handle(MessageCreatureKnowledge message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        PlayerEntity player = ClientManager.getInstance().getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return;
        }
        playerExt.beastiary.addCreatureKnowledge(new CreatureKnowledge(playerExt.beastiary, message.creatureName, message.rank));
    }

    public static MessageCreatureKnowledge decode(PacketBuffer packet) {
        MessageCreatureKnowledge message = new MessageCreatureKnowledge();
        try {
            message.creatureName = packet.func_150789_c(256);
            message.rank = packet.readInt();
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
        return message;
    }

    public static void encode(MessageCreatureKnowledge message, PacketBuffer packet) {
        packet.func_180714_a(message.creatureName);
        packet.writeInt(message.rank);
    }
}

