/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventSchedule;
import com.lycanitesmobs.core.mobevent.trigger.AltarMobEventTrigger;
import com.lycanitesmobs.core.mobevent.trigger.MobEventTrigger;
import com.lycanitesmobs.core.mobevent.trigger.RandomMobEventTrigger;
import com.lycanitesmobs.core.mobevent.trigger.TickMobEventTrigger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MobEventListener {
    protected static MobEventListener INSTANCE;
    public List<RandomMobEventTrigger> randomMobEventTriggers = new ArrayList<RandomMobEventTrigger>();
    public List<TickMobEventTrigger> tickMobEventTriggers = new ArrayList<TickMobEventTrigger>();

    public static MobEventListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobEventListener();
        }
        return INSTANCE;
    }

    public boolean addTrigger(MobEventTrigger mobEventTrigger) {
        if (mobEventTrigger instanceof RandomMobEventTrigger && !this.randomMobEventTriggers.contains(mobEventTrigger)) {
            this.randomMobEventTriggers.add((RandomMobEventTrigger)mobEventTrigger);
            return true;
        }
        if (mobEventTrigger instanceof TickMobEventTrigger && !this.tickMobEventTriggers.contains(mobEventTrigger)) {
            this.tickMobEventTriggers.add((TickMobEventTrigger)mobEventTrigger);
            return true;
        }
        return false;
    }

    public void removeTrigger(MobEventTrigger mobEventTrigger) {
        if (this.randomMobEventTriggers.contains(mobEventTrigger)) {
            this.randomMobEventTriggers.remove(mobEventTrigger);
        }
        if (this.tickMobEventTriggers.contains(mobEventTrigger)) {
            this.tickMobEventTriggers.remove(mobEventTrigger);
        }
        if (mobEventTrigger instanceof AltarMobEventTrigger) {
            AltarMobEventTrigger altarMobEventTrigger = (AltarMobEventTrigger)mobEventTrigger;
            altarMobEventTrigger.onRemove();
        }
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        if (!MobEventManager.getInstance().mobEventsEnabled || world.func_175659_aa() == Difficulty.PEACEFUL) {
            if (worldExt.serverWorldEventPlayer != null) {
                worldExt.stopWorldEvent();
            }
            return;
        }
        if (worldExt.lastEventScheduleTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastEventScheduleTime = world.func_82737_E();
        if (world.func_217369_A().size() < 1) {
            return;
        }
        for (MobEventSchedule mobEventSchedule : MobEventManager.getInstance().mobEventSchedules) {
            if (!mobEventSchedule.canStart(world)) continue;
            mobEventSchedule.start(worldExt);
        }
        for (TickMobEventTrigger mobEventTrigger : this.tickMobEventTriggers) {
            mobEventTrigger.onTick(world, worldExt.lastEventScheduleTime);
        }
        if (MobEventManager.getInstance().mobEventsRandom) {
            if (MobEventManager.getInstance().minEventsRandomDay > 0) {
                long l = worldExt.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D();
                if (Math.floor((double)l / 24000.0) < (double)MobEventManager.getInstance().minEventsRandomDay) {
                    return;
                }
            }
            if (worldExt.getWorldEventStartTargetTime() <= 0L || worldExt.getWorldEventStartTargetTime() > world.func_82737_E() + (long)MobEventManager.getInstance().maxTicksUntilEvent) {
                worldExt.setWorldEventStartTargetTime(world.func_82737_E() + (long)worldExt.getRandomEventDelay(world.field_73012_v));
            }
            if (world.func_82737_E() >= worldExt.getWorldEventStartTargetTime()) {
                this.triggerRandomMobEvent(world, worldExt);
            }
        }
    }

    public void triggerRandomMobEvent(World world, ExtendedWorld worldExt) {
        ArrayList<RandomMobEventTrigger> validTriggers = new ArrayList<RandomMobEventTrigger>();
        int totalWeights = 0;
        int highestPriority = 0;
        for (RandomMobEventTrigger mobEventTrigger : this.randomMobEventTriggers) {
            if (mobEventTrigger.priority < highestPriority || !mobEventTrigger.canTrigger(world, null)) continue;
            if (mobEventTrigger.priority > highestPriority) {
                totalWeights = 0;
                validTriggers.clear();
            }
            totalWeights += mobEventTrigger.weight;
            highestPriority = mobEventTrigger.priority;
            validTriggers.add(mobEventTrigger);
        }
        if (totalWeights <= 0) {
            return;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = world.field_73012_v.nextInt(totalWeights - 1) + 1;
        }
        int searchWeight = 0;
        for (RandomMobEventTrigger mobEventTrigger : validTriggers) {
            if (mobEventTrigger.weight + searchWeight > randomWeight) {
                mobEventTrigger.trigger(world, null, new BlockPos(0, 0, 0), 1);
                return;
            }
            searchWeight += mobEventTrigger.weight;
        }
    }
}

