/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.special;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.BaseItem;
import com.lycanitesmobs.core.pets.PetEntry;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemSoulstone
extends BaseItem {
    public CreatureType creatureType;

    public ItemSoulstone(Item.Properties properties, @Nullable CreatureType creatureType) {
        super(properties);
        this.modInfo = LycanitesMobs.modInfo;
        this.creatureType = creatureType;
        this.itemName = "soulstone";
        if (creatureType != null) {
            this.itemName = this.itemName + creatureType.getName();
        }
        this.setup();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (this.creatureType == null) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        int randomCreatureIndex = player.func_70681_au().nextInt(this.creatureType.tameableCreatures.size());
        CreatureInfo creatureInfo = this.creatureType.tameableCreatures.get(randomCreatureIndex);
        if (creatureInfo == null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        LivingEntity entity = creatureInfo.createEntity(world);
        if (entity != null) {
            entity.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            world.func_217376_c((Entity)entity);
            if (!player.func_130014_f_().field_72995_K && entity instanceof TameableCreatureEntity) {
                ((TameableCreatureEntity)entity).setPlayerOwner(player);
            }
            this.applySoulstoneToEntity(player, entity);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (this.creatureType == null && this.applySoulstoneToEntity(player, entity)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(Math.max(0, stack.func_190916_E() - 1));
            }
            if (stack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            return true;
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    public boolean applySoulstoneToEntity(PlayerEntity player, LivingEntity entity) {
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return false;
        }
        if (!(entity instanceof TameableCreatureEntity)) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.soulstone.invalid", new Object[0]));
            }
            return false;
        }
        TameableCreatureEntity entityTameable = (TameableCreatureEntity)entity;
        CreatureInfo creatureInfo = entityTameable.creatureInfo;
        if (!creatureInfo.isTameable() || entityTameable.getOwner() != player) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.soulstone.untamed", new Object[0]));
            }
            return false;
        }
        if (entityTameable.getPetEntry() != null) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.soulstone.exists", new Object[0]));
            }
            return false;
        }
        if (player.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197632_y, entity.field_70165_t + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70163_u + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70161_v + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, 0.0, 0.0, 0.0);
            }
        }
        if (!player.func_130014_f_().field_72995_K) {
            String petType = "pet";
            if (entityTameable.creatureInfo.isMountable()) {
                petType = "mount";
            }
            ITextComponent message = new TranslationTextComponent("message.soulstone." + petType + ".added.prefix", new Object[0]).func_150258_a(" ").func_150257_a(creatureInfo.getTitle()).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("message.soulstone." + petType + ".added.suffix", new Object[0]));
            player.func_145747_a(message);
            PetEntry petEntry = PetEntry.createFromEntity(player, entityTameable, petType);
            playerExt.petManager.addEntry(petEntry);
            playerExt.sendPetEntriesToPlayer(petType);
            petEntry.assignEntity((Entity)entity);
            entityTameable.setPetEntry(petEntry);
        }
        return true;
    }
}

