/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DamageEquipmentFeature
extends EquipmentFeature {
    public int damageAmount = 1;
    public double damageCooldown = 1.0;
    public double damageKnockback = 0.0;
    public double damageRange = 0.0;
    public double damageSweep = 45.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("damageAmount")) {
            this.damageAmount = json.get("damageAmount").getAsInt();
        }
        if (json.has("damageCooldown")) {
            this.damageCooldown = json.get("damageCooldown").getAsDouble();
        }
        if (json.has("damageKnockback")) {
            this.damageKnockback = json.get("damageKnockback").getAsDouble();
        }
        if (json.has("damageRange")) {
            this.damageRange = json.get("damageRange").getAsDouble();
        }
        if (json.has("damageSweep")) {
            this.damageSweep = json.get("damageSweep").getAsDouble();
        }
    }

    @Override
    public ITextComponent getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        ITextComponent description = new TranslationTextComponent("equipment.feature." + this.featureType, new Object[0]).func_150258_a(" " + this.damageAmount);
        if (this.damageCooldown > 0.0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.cooldown", new Object[0])).func_150258_a(" " + this.damageCooldown);
        }
        if (this.damageKnockback > 0.0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.knockback", new Object[0])).func_150258_a(" " + this.damageKnockback);
        }
        if (this.damageRange > 0.0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.range", new Object[0])).func_150258_a(" " + this.damageRange);
        }
        if (this.damageSweep > 45.0) {
            description.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("equipment.feature.damage.sweep", new Object[0])).func_150258_a(" " + this.damageSweep);
        }
        return description;
    }
}

