/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.google.common.collect.Multimap;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BaseItem
extends Item {
    public static int DESCRIPTION_WIDTH = 200;
    public String itemName = "unamed_item";
    public ModInfo modInfo = LycanitesMobs.modInfo;

    public BaseItem(Item.Properties properties) {
        super(properties);
    }

    public void setup() {
        this.setRegistryName(this.modInfo.modid, this.itemName);
    }

    @Nonnull
    public String func_77658_a() {
        return "item." + this.modInfo.modid + "." + this.itemName;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[0]);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ITextComponent description = this.getDescription(stack, worldIn, tooltip, flag);
        if (!"".equalsIgnoreCase(description.func_150254_d())) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List formattedDescriptionList = fontRenderer.func_78271_c(description.func_150254_d(), DESCRIPTION_WIDTH);
            for (String formattedDescription : formattedDescriptionList) {
                tooltip.add((ITextComponent)new StringTextComponent(formattedDescription));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flag);
    }

    public ITextComponent getDescription(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        return new TranslationTextComponent(this.func_77658_a() + ".description", new Object[0]);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return super.onEntityItemUpdate(stack, entity);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return super.func_77659_a(world, player, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        return super.func_111207_a(stack, player, entity, hand);
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity entity, int useRemaining) {
        super.onUsingTick(itemStack, entity, useRemaining);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return super.func_77661_b(itemStack);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack repairStack) {
        return super.func_82789_a(itemStack, repairStack);
    }

    public void playSound(World world, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, x, y, z, sound, category, volume, pitch);
    }

    public void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184133_a(null, pos, sound, category, volume, pitch);
    }
}

