/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.dispenser.BaseProjectileDispenseBehaviour;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import com.lycanitesmobs.core.item.ItemCharge;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ProjectileInfo {
    protected String name;
    public boolean enabled = true;
    @Nonnull
    public Class<? extends BaseProjectileEntity> entityClass = CustomProjectileEntity.class;
    public Constructor<? extends BaseProjectileEntity> entityConstructor;
    public String modelClassName;
    public ModInfo modInfo;
    protected EntityType<? extends BaseProjectileEntity> entityType;
    public Item chargeItem;
    public String chargeItemName;
    public BaseProjectileDispenseBehaviour dispenserBehaviour;
    public float width = 0.75f;
    public float height = 0.75f;
    public float scale = 0.5f;
    public int lifetime = 200;
    public int damage = 1;
    public int pierce = 1;
    public double knockbackChance = 0.0;
    public int effectDuration = 1;
    public int effectAmplifier = 1;
    public double velocity = 1.1;
    public double weight = 1.0;
    public List<ElementInfo> elements = new ArrayList<ElementInfo>();
    public List<ProjectileBehaviour> behaviours = new ArrayList<ProjectileBehaviour>();
    public boolean waterproof = false;
    public boolean lavaproof = false;
    public boolean cutGrass = false;
    public boolean ripper = false;
    public boolean pierceBlocks = false;
    public boolean impactSound = false;
    public boolean glow = false;

    public ProjectileInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        this.chargeItemName = json.has("chargeItemName") ? json.get("chargeItemName").getAsString() : this.name + "charge";
        try {
            if (json.has("entityClass")) {
                this.entityClass = Class.forName(json.get("entityClass").getAsString());
            }
            this.entityConstructor = this.entityClass.getConstructor(EntityType.class, World.class);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "[Projectile] Unable to find the Java Entity Class: " + json.get("entityClass").getAsString() + " for " + this.getName());
            throw new RuntimeException(e);
        }
        if (json.has("modelClass")) {
            this.modelClassName = json.get("modelClass").getAsString();
        }
        if (json.has("width")) {
            this.width = json.get("width").getAsFloat();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsFloat();
        }
        if (json.has("scale")) {
            this.scale = json.get("scale").getAsFloat();
        }
        if (json.has("damage")) {
            this.damage = json.get("damage").getAsInt();
        }
        if (json.has("pierce")) {
            this.pierce = json.get("pierce").getAsInt();
        }
        if (json.has("knockbackChance")) {
            this.knockbackChance = json.get("knockbackChance").getAsDouble();
        }
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectAmplifier")) {
            this.effectAmplifier = json.get("effectAmplifier").getAsInt();
        }
        if (json.has("velocity")) {
            this.velocity = json.get("velocity").getAsDouble();
        }
        if (json.has("weight")) {
            this.weight = json.get("weight").getAsDouble();
        }
        if (json.has("lifetime")) {
            this.lifetime = json.get("lifetime").getAsInt();
        }
        List<Object> elementNames = new ArrayList();
        if (json.has("elements")) {
            elementNames = JSONHelper.getJsonStrings(json.get("elements").getAsJsonArray());
        }
        this.elements.clear();
        for (String elementName : elementNames) {
            ElementInfo element = ElementManager.getInstance().getElement(elementName);
            if (element == null) {
                throw new RuntimeException("[Creature] Unable to initialise Projectile Info for " + this.getName() + " as the element " + elementName + " cannot be found.");
            }
            this.elements.add(element);
        }
        if (json.has("behaviours")) {
            JsonArray jsonArray = json.get("behaviours").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject behaviorJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                ProjectileBehaviour projectileBehaviour = ProjectileBehaviour.createFromJSON(behaviorJson);
                if (projectileBehaviour != null) {
                    this.behaviours.add(projectileBehaviour);
                    continue;
                }
                LycanitesMobs.logWarning("", "Unable to load Projectile Behaviour: " + behaviorJson.get("type").getAsString());
            }
        }
        if (json.has("waterproof")) {
            this.waterproof = json.get("waterproof").getAsBoolean();
        }
        if (json.has("lavaproof")) {
            this.lavaproof = json.get("lavaproof").getAsBoolean();
        }
        if (json.has("cutGrass")) {
            this.cutGrass = json.get("cutGrass").getAsBoolean();
        }
        if (json.has("ripper")) {
            this.ripper = json.get("ripper").getAsBoolean();
        }
        if (json.has("pierceBlocks")) {
            this.pierceBlocks = json.get("pierceBlocks").getAsBoolean();
        }
        if (json.has("impactSound")) {
            this.impactSound = json.get("impactSound").getAsBoolean();
        }
        if (json.has("glow")) {
            this.glow = json.get("glow").getAsBoolean();
        }
    }

    public void load() {
        this.chargeItem = ObjectManager.getItem(this.chargeItemName);
        if (this.chargeItem == null) {
            Item.Properties properties = new Item.Properties();
            properties.func_200916_a(ItemManager.getInstance().itemsGroup);
            this.chargeItem = new ItemCharge(properties, this);
            ObjectManager.addItem(this.chargeItemName, this.chargeItem);
        }
        this.dispenserBehaviour = new BaseProjectileDispenseBehaviour(this);
        DispenserBlock.func_199774_a((IItemProvider)this.chargeItem, (IDispenseItemBehavior)this.dispenserBehaviour);
        ObjectManager.addSound(this.name, this.modInfo, "projectile." + this.name);
        if (this.impactSound) {
            ObjectManager.addSound(this.name + "_impact", this.modInfo, "projectile." + this.name + ".impact");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEntityId() {
        return this.modInfo.modid + ":" + this.getName();
    }

    @Nonnull
    public EntityType<? extends BaseProjectileEntity> getEntityType() {
        if (this.entityType == null) {
            EntityType.Builder entityTypeBuilder = EntityType.Builder.func_220322_a((EntityType.IFactory)EntityFactory.getInstance(), (EntityClassification)EntityClassification.MISC);
            entityTypeBuilder.setTrackingRange(40);
            entityTypeBuilder.setUpdateInterval(3);
            entityTypeBuilder.setShouldReceiveVelocityUpdates(true);
            entityTypeBuilder.func_220321_a(this.width, this.height);
            this.entityType = entityTypeBuilder.func_206830_a(this.getName());
            this.entityType.setRegistryName(this.modInfo.modid, this.getName());
            EntityFactory.getInstance().addEntityType(this.entityType, this.entityConstructor, this.getName());
        }
        return this.entityType;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.modInfo.modid, this.getName());
    }

    public String getLocalisationKey() {
        return this.modInfo.modid + "." + this.getName();
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("entity." + this.getLocalisationKey() + ".name", new Object[0]);
    }

    public BaseProjectileEntity createProjectile(World world, LivingEntity entityLivingBase) {
        return new CustomProjectileEntity(this.getEntityType(), world, entityLivingBase, this);
    }

    public BaseProjectileEntity createProjectile(World world, double x, double y, double z) {
        return new CustomProjectileEntity(this.getEntityType(), world, x, y, z, this);
    }

    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound(this.name);
    }

    public SoundEvent getImpactSound() {
        return ObjectManager.getSound(this.name + "_impact");
    }
}

