/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;

public class ObjectLists {
    public static Map<String, List<ItemStack>> itemLists = new HashMap<String, List<ItemStack>>();
    public static Map<String, List<EntityType>> entityLists = new HashMap<String, List<EntityType>>();
    public static Map<String, List<Effect>> effectLists = new HashMap<String, List<Effect>>();
    public static Map<String, Effect> allEffects = new HashMap<String, Effect>();

    public static void addItem(String list, Object object) {
        if (!(object instanceof Item || object instanceof Block || object instanceof ItemStack || object instanceof String)) {
            return;
        }
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            itemLists.put(list, new ArrayList());
        }
        ItemStack itemStack = null;
        if (object instanceof Item) {
            itemStack = new ItemStack((IItemProvider)((Item)object));
        } else if (object instanceof Block) {
            itemStack = new ItemStack((IItemProvider)((Block)object));
        } else if (object instanceof ItemStack) {
            itemStack = (ItemStack)object;
        } else if (ObjectManager.getItem((String)object) != null) {
            itemStack = new ItemStack((IItemProvider)ObjectManager.getItem((String)object));
        } else if (ObjectManager.getBlock((String)object) != null) {
            itemStack = new ItemStack((IItemProvider)ObjectManager.getBlock((String)object));
        }
        if (itemStack != null) {
            itemLists.get(list).add(itemStack);
        }
    }

    public static void addEntity(String list, Object object) {
        CreatureInfo creatureInfo;
        if (!(object instanceof Entity) && !(object instanceof String)) {
            return;
        }
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            entityLists.put(list, new ArrayList());
        }
        EntityType<? extends LivingEntity> entityType = null;
        if (object instanceof String && (creatureInfo = CreatureManager.getInstance().getCreature((String)object)) != null) {
            entityType = creatureInfo.getEntityType();
        }
        if (entityType != null) {
            entityLists.get(list).add(entityType);
        }
    }

    public static void addEffect(String list, Effect effect, String effectName) {
        if (effect == null) {
            return;
        }
        allEffects.put(effectName, effect);
        list = list.toLowerCase();
        if (!effectLists.containsKey(list)) {
            effectLists.put(list, new ArrayList());
        }
        effectLists.get(list).add(effect);
    }

    public static List<ItemStack> getItems(String list) {
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<ItemStack>();
        }
        return itemLists.get(list);
    }

    public static List<EntityType> getEntites(String list) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<EntityType>();
        }
        return entityLists.get(list);
    }

    public static List<Effect> getEffects(String list) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return new ArrayList<Effect>();
        }
        return effectLists.get(list);
    }

    public static boolean inItemList(String list, ItemStack testStack) {
        list = list.toLowerCase();
        if (testStack == null || testStack.func_190926_b()) {
            return false;
        }
        if (!itemLists.containsKey(list)) {
            return false;
        }
        for (ItemStack listStack : itemLists.get(list)) {
            if (testStack.func_77973_b() != listStack.func_77973_b() || testStack.func_77952_i() != listStack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean inEntityList(String list, Class testClass) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return false;
    }

    public static boolean inEffectList(String list, Effect effect) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return effectLists.get(list).contains(effect);
    }

    public static void createVanillaLists() {
        ObjectLists.addItem("rawmeat", Items.field_151082_bd);
        ObjectLists.addItem("rawmeat", Items.field_151147_al);
        ObjectLists.addItem("rawmeat", Items.field_151076_bf);
        ObjectLists.addItem("cookedmeat", Items.field_151083_be);
        ObjectLists.addItem("cookedmeat", Items.field_151157_am);
        ObjectLists.addItem("cookedmeat", Items.field_151077_bg);
        ObjectLists.addItem("vegetables", Items.field_151015_O);
        ObjectLists.addItem("vegetables", Items.field_151172_bF);
        ObjectLists.addItem("vegetables", Items.field_151174_bG);
        ObjectLists.addItem("fruit", Items.field_151034_e);
        ObjectLists.addItem("fruit", Items.field_151127_ba);
        ObjectLists.addItem("fruit", Blocks.field_150423_aK);
        ObjectLists.addItem("fruit", Items.field_151158_bO);
        ObjectLists.addItem("rawfish", Items.field_196086_aW);
        ObjectLists.addItem("rawfish", Items.field_196087_aX);
        ObjectLists.addItem("cookedfish", Items.field_196102_ba);
        ObjectLists.addItem("cookedfish", Items.field_196104_bb);
        ObjectLists.addItem("cactusfood", Items.field_222079_lj);
        ObjectLists.addItem("mushrooms", Items.field_151009_A);
        ObjectLists.addItem("mushrooms", Items.field_221694_bi);
        ObjectLists.addItem("mushrooms", Items.field_221692_bh);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150338_P);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150420_aW);
        ObjectLists.addItem("mushrooms", Blocks.field_150419_aX);
        ObjectLists.addItem("sweets", Items.field_151102_aT);
        ObjectLists.addItem("sweets", Items.field_196130_bo);
        ObjectLists.addItem("sweets", Items.field_151106_aX);
        ObjectLists.addItem("sweets", Blocks.field_150414_aQ);
        ObjectLists.addItem("sweets", Items.field_151158_bO);
        ObjectLists.addItem("fuel", Items.field_151044_h);
        ObjectLists.addEffect("buffs", Effects.field_76420_g, "strength");
        ObjectLists.addEffect("buffs", Effects.field_76422_e, "haste");
        ObjectLists.addEffect("buffs", Effects.field_76426_n, "fire_resistance");
        ObjectLists.addEffect("buffs", Effects.field_76432_h, "instant_health");
        ObjectLists.addEffect("buffs", Effects.field_76441_p, "invisibility");
        ObjectLists.addEffect("buffs", Effects.field_76430_j, "jump_boost");
        ObjectLists.addEffect("buffs", Effects.field_76424_c, "speed");
        ObjectLists.addEffect("buffs", Effects.field_76439_r, "night_vision");
        ObjectLists.addEffect("buffs", Effects.field_76428_l, "regeneration");
        ObjectLists.addEffect("buffs", Effects.field_76429_m, "resistance");
        ObjectLists.addEffect("buffs", Effects.field_76427_o, "water_breathing");
        ObjectLists.addEffect("buffs", Effects.field_180152_w, "health_boost");
        ObjectLists.addEffect("buffs", Effects.field_76444_x, "absorption");
        ObjectLists.addEffect("buffs", Effects.field_76443_y, "saturation");
        ObjectLists.addEffect("buffs", Effects.field_188423_x, "glowing");
        ObjectLists.addEffect("buffs", Effects.field_188424_y, "levitation");
        ObjectLists.addEffect("buffs", Effects.field_188425_z, "luck");
        ObjectLists.addEffect("debuffs", Effects.field_76440_q, "blindness");
        ObjectLists.addEffect("debuffs", Effects.field_76431_k, "nausea");
        ObjectLists.addEffect("debuffs", Effects.field_76419_f, "mining_fatigue");
        ObjectLists.addEffect("debuffs", Effects.field_76433_i, "instant_damage");
        ObjectLists.addEffect("debuffs", Effects.field_76438_s, "hunger");
        ObjectLists.addEffect("debuffs", Effects.field_76421_d, "slowness");
        ObjectLists.addEffect("debuffs", Effects.field_76436_u, "poison");
        ObjectLists.addEffect("debuffs", Effects.field_76437_t, "weakness");
        ObjectLists.addEffect("debuffs", Effects.field_82731_v, "wither");
        ObjectLists.addEffect("debuffs", Effects.field_189112_A, "unluck");
    }

    public static void addFromConfig(String listName) {
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ShovelItem) {
            return true;
        }
        return itemStack.getHarvestLevel(ToolType.PICKAXE, null, null) != -1;
    }

    public static boolean isAxe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof AxeItem) {
            return true;
        }
        return itemStack.getHarvestLevel(ToolType.AXE, null, null) != -1;
    }

    public static boolean isShovel(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ShovelItem) {
            return true;
        }
        return itemStack.getHarvestLevel(ToolType.SHOVEL, null, null) != -1;
    }

    public static boolean isName(Item item, String name) {
        if (item == null) {
            return false;
        }
        String itemName = item.func_77658_a().toLowerCase();
        return itemName.contains(name);
    }

    public static boolean isName(Block block, String name) {
        if (block == null) {
            return false;
        }
        name = name.toLowerCase();
        String blockName = block.func_149739_a().toLowerCase();
        return blockName.contains(name);
    }
}

