/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.GenericItem;
import java.util.Iterator;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class ItemInfo {
    public GenericItem item;
    protected String name;
    public ModInfo group;

    public ItemInfo(ModInfo group) {
        this.group = group;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        LycanitesMobs.logDebug("", "Loading item " + this.name + " from JSON...");
        String modelName = null;
        if (json.has("model")) {
            modelName = json.get("model").getAsString();
        }
        ItemGroup group = ItemManager.getInstance().itemsGroup;
        if (json.has("group")) {
            String groupName = json.get("group").getAsString();
            if ("blocks".equalsIgnoreCase(groupName)) {
                group = ItemManager.getInstance().blocksGroup;
            }
            if ("creatures".equalsIgnoreCase(groupName)) {
                group = ItemManager.getInstance().creaturesGroups;
            }
        }
        int maxStackSize = 64;
        if (json.has("maxStackSize")) {
            maxStackSize = json.get("maxStackSize").getAsInt();
        }
        Food food = null;
        if (json.has("food")) {
            JsonObject foodJson = json.get("food").getAsJsonObject();
            Food.Builder foodBuilder = new Food.Builder();
            foodBuilder.func_221456_a(foodJson.get("hunger").getAsInt());
            foodBuilder.func_221454_a(foodJson.get("saturation").getAsFloat());
            if (!foodJson.has("alwaysEdible") || foodJson.get("alwaysEdible").getAsBoolean()) {
                foodBuilder.func_221455_b();
            }
            if (foodJson.has("fast") && foodJson.get("fast").getAsBoolean()) {
                foodBuilder.func_221457_c();
            }
            if (foodJson.has("meat") && foodJson.get("meat").getAsBoolean()) {
                foodBuilder.func_221451_a();
            }
            if (foodJson.has("effects")) {
                JsonArray effectsJson = foodJson.getAsJsonArray("effects");
                Iterator jsonIterator = effectsJson.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject foodEffectJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    String[] effectIds = foodEffectJson.get("effectId").getAsString().split(":");
                    EffectBase effect = "minecraft".equals(effectIds[0]) ? ObjectLists.allEffects.get(effectIds[1]) : ObjectManager.getEffect(effectIds[1]);
                    EffectInstance effectInstance = new EffectInstance((Effect)effect, foodEffectJson.get("duration").getAsInt() * 20, foodEffectJson.get("amplifier").getAsInt());
                    Float chance = Float.valueOf(1.0f);
                    if (foodEffectJson.has("chance")) {
                        chance = Float.valueOf(foodEffectJson.get("chance").getAsFloat());
                    }
                    foodBuilder.func_221452_a(effectInstance, chance.floatValue());
                }
            }
            food = foodBuilder.func_221453_d();
        }
        Item.Properties properties = new Item.Properties();
        properties.func_200916_a(group);
        properties.func_200917_a(maxStackSize);
        if (food != null) {
            properties.func_221540_a(food);
        }
        this.item = new GenericItem(properties, this.name);
        this.item.modelName = modelName;
    }

    public GenericItem getItem() {
        return this.item;
    }

    public String getName() {
        return this.name;
    }
}

