/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.HashMap;
import java.util.Map;

public class ElementManager
extends JSONLoader {
    public static ElementManager INSTANCE;
    public Map<String, ElementInfo> elements = new HashMap<String, ElementInfo>();

    public static ElementManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ElementManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJson(ModInfo groupInfo) {
        this.elements.clear();
        this.loadAllJson(groupInfo, "Element", "elements", "name", false, null, FileLoader.COMMON, StreamLoader.COMMON);
        for (ElementInfo elementInfo : this.elements.values()) {
            elementInfo.init();
        }
        LycanitesMobs.logDebug("Element", "Complete! " + this.elements.size() + " JSON Elements Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        ElementInfo elementInfo = new ElementInfo();
        elementInfo.loadFromJSON(json);
        if (elementInfo.name == null) {
            LycanitesMobs.logWarning("", "Unable to load " + loadGroup + " json due to missing name.");
            return;
        }
        this.elements.put(elementInfo.name, elementInfo);
    }

    public ElementInfo getElement(String elementName) {
        if (!this.elements.containsKey(elementName)) {
            return null;
        }
        return this.elements.get(elementName);
    }
}

