/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.projectile;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.LaserProjectileEntity;
import com.lycanitesmobs.core.entity.creature.EntityBeholder;
import com.lycanitesmobs.core.entity.projectile.EntityArcaneLaser;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityArcaneLaserStorm
extends BaseProjectileEntity {
    public Entity shootingEntity;
    public int expireTime = 15;
    public int laserMax = 7;
    List<LaserProjectileEntity> lasers = new ArrayList<LaserProjectileEntity>();
    int laserTick = 0;

    public EntityArcaneLaserStorm(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityArcaneLaserStorm(EntityType<? extends BaseProjectileEntity> entityType, World world, LivingEntity entityLiving) {
        super(entityType, world, entityLiving);
    }

    public EntityArcaneLaserStorm(EntityType<? extends BaseProjectileEntity> entityType, World world, double par2, double par4, double par6) {
        super(entityType, world, par2, par4, par6);
    }

    @Override
    public void setup() {
        this.entityName = "arcanelaserstorm";
        this.modInfo = LycanitesMobs.modInfo;
        this.setDamage(4);
        this.setProjectileScale(4.0f);
        this.ripper = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            this.updateLasers();
        }
        if (this.field_70163_u > (double)(this.func_130014_f_().func_72940_L() + 20)) {
            this.func_70106_y();
        }
        if (this.field_70173_aa >= this.expireTime * 20) {
            this.func_70106_y();
        }
    }

    public void updateLasers() {
        World world = this.func_130014_f_();
        while (this.lasers.size() < this.laserMax) {
            EntityArcaneLaser laser;
            if (this.func_85052_h() != null) {
                laser = new EntityArcaneLaser(ProjectileManager.getInstance().oldProjectileTypes.get(EntityArcaneLaser.class), world, this.func_85052_h(), 20, 10, (Entity)this);
                laser.field_70165_t = this.field_70165_t;
                laser.field_70163_u = this.field_70163_u;
                laser.field_70161_v = this.field_70161_v;
            } else {
                laser = new EntityArcaneLaser(ProjectileManager.getInstance().oldProjectileTypes.get(EntityArcaneLaser.class), world, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20, 10, (Entity)this);
            }
            laser.useEntityAttackTarget = false;
            this.lasers.add(laser);
            world.func_217376_c((Entity)laser);
        }
        int laserCount = 0;
        for (LaserProjectileEntity laser : this.lasers) {
            laser.setTime(20);
            double[] target = new double[]{this.field_70165_t, this.field_70163_u, this.field_70161_v};
            if (laserCount == 0) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, 135.0);
            }
            if (laserCount == 1) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, 90.0);
            }
            if (laserCount == 2) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, 45.0);
            }
            if (laserCount == 3) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, 0.0);
            }
            if (laserCount == 4) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, -45.0);
            }
            if (laserCount == 5) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, -90.0);
            }
            if (laserCount == 6) {
                target = this.getFacingPosition((Entity)this, laser.laserLength, -135.0);
            }
            target[1] = laserCount == 0 || laserCount == 2 || laserCount == 4 || laserCount == 6 ? target[1] - (double)(laser.laserLength / 2.0f) : target[1] + (double)(laser.laserLength / 2.0f);
            target[0] = target[0] + (double)(MathHelper.func_76134_b((float)((float)this.laserTick * 0.25f)) * 1.0f - 0.5f);
            target[1] = target[1] + (double)(MathHelper.func_76134_b((float)((float)this.laserTick * 0.25f)) * 1.0f - 0.5f);
            target[2] = target[2] + (double)(MathHelper.func_76134_b((float)((float)this.laserTick * 0.25f)) * 1.0f - 0.5f);
            laser.setTarget(target[0], target[1], target[2]);
            ++laserCount;
        }
        ++this.laserTick;
    }

    @Override
    protected float func_70185_h() {
        return 1.0E-4f;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.func_85052_h() != null && this.func_85052_h().func_184187_bx() == entity) {
            return;
        }
        if (this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            int explosionRadius = 2;
            if (this.func_85052_h() != null && this.func_85052_h() instanceof BaseCreatureEntity) {
                BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)this.func_85052_h();
                if (baseCreatureEntity instanceof EntityBeholder && !((EntityBeholder)baseCreatureEntity).beholderGreifing) {
                    return;
                }
                if (baseCreatureEntity.getOwner() == entity || baseCreatureEntity.func_184179_bs() == entity) {
                    super.onImpactComplete(this.func_180425_c());
                    return;
                }
                if (baseCreatureEntity.getSubspeciesIndex() > 0) {
                    explosionRadius += 2;
                }
                if (baseCreatureEntity.getSubspeciesIndex() > 2) {
                    explosionRadius += 2;
                }
            }
            this.func_130014_f_().func_217385_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionRadius, Explosion.Mode.BREAK);
        }
        super.onImpactComplete(this.func_180425_c());
    }

    @Override
    public void onImpactVisuals() {
        for (int i = 0; i < 8; ++i) {
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public SoundEvent getLaunchSound() {
        return ObjectManager.getSound(this.entityName);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

