/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class DirectNavigator {
    BaseCreatureEntity host;
    public BlockPos targetPosition;
    public double flyingSpeed = 1.0;
    public boolean faceMovement = true;
    public double speedModifier = 1.0;
    private double randomStrafeAngle = 0.0;

    public DirectNavigator(BaseCreatureEntity setHost) {
        this.host = setHost;
    }

    public DirectNavigator setSpeed(double setSpeed) {
        this.flyingSpeed = setSpeed;
        return this;
    }

    public DirectNavigator setFacing(boolean facing) {
        this.faceMovement = facing;
        return this;
    }

    public boolean setTargetPosition(BlockPos targetPosition, double setSpeedMod) {
        if (this.isTargetPositionValid(targetPosition)) {
            this.targetPosition = targetPosition;
            this.speedModifier = setSpeedMod;
            return true;
        }
        return false;
    }

    public boolean setTargetPosition(Entity targetEntity, double setSpeedMod) {
        return this.setTargetPosition(new BlockPos((int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v), setSpeedMod);
    }

    public boolean clearTargetPosition(double setSpeedMod) {
        return this.setTargetPosition((BlockPos)null, setSpeedMod);
    }

    public boolean isTargetPositionValid() {
        return this.isTargetPositionValid(this.targetPosition);
    }

    public boolean isTargetPositionValid(BlockPos targetPosition) {
        if (targetPosition == null) {
            return true;
        }
        if (this.host.isStrongSwimmer() && this.host.isSwimmable(targetPosition.func_177958_n(), targetPosition.func_177956_o(), targetPosition.func_177952_p())) {
            return true;
        }
        if (!this.host.isFlying()) {
            return false;
        }
        if (!this.host.func_130014_f_().func_175623_d(new BlockPos(targetPosition.func_177958_n(), targetPosition.func_177956_o(), targetPosition.func_177952_p())) && !this.host.field_70145_X) {
            return false;
        }
        return targetPosition.func_177956_o() >= 3;
    }

    public double distanceToTargetPosition() {
        return this.host.func_70092_e(this.targetPosition.func_177958_n(), this.targetPosition.func_177956_o(), this.targetPosition.func_177952_p());
    }

    public boolean atTargetPosition() {
        if (this.targetPosition != null) {
            double speed = this.host.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0;
            return this.distanceToTargetPosition() <= (double)this.host.func_213305_a((Pose)Pose.STANDING).field_220315_a + speed;
        }
        return true;
    }

    public void updateFlight() {
        if (this.targetPosition == null || this.atTargetPosition()) {
            return;
        }
        double speed = this.host.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 2.0;
        BlockPos pos = this.host.getFacingPosition(this.targetPosition.func_177958_n(), this.targetPosition.func_177956_o(), this.targetPosition.func_177952_p(), 1.0, this.randomStrafeAngle);
        double dirX = (double)pos.func_177958_n() - this.host.field_70165_t;
        double dirY = (double)this.targetPosition.func_177956_o() + 0.1 - this.host.field_70163_u;
        double dirZ = (double)pos.func_177952_p() - this.host.field_70161_v;
        double motionX = (Math.signum(dirX) * speed - this.host.func_213322_ci().func_82615_a()) * (double)0.1f * 0.3 * this.speedModifier;
        double motionY = (Math.signum(dirY) * speed - this.host.func_213322_ci().func_82617_b()) * (double)0.1f * 0.3 * this.speedModifier;
        double motionZ = (Math.signum(dirZ) * speed - this.host.func_213322_ci().func_82616_c()) * (double)0.1f * 0.3 * this.speedModifier;
        this.host.func_213317_d(this.host.func_213322_ci().func_72441_c(motionX, motionY, motionZ));
        float fullAngle = (float)(Math.atan2(this.host.func_213322_ci().func_82616_c(), this.host.func_213322_ci().func_82615_a()) * 180.0 / Math.PI) - 90.0f;
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        this.host.field_191988_bg = 0.5f;
        if (this.faceMovement && this.host.func_70638_az() != null && (this.host.func_213322_ci().func_82615_a() > (double)0.025f || this.host.func_213322_ci().func_82616_c() > (double)0.025f)) {
            this.host.field_70177_z += angle;
        }
    }

    public void flightMovement(double moveStrafe, double moveForward) {
        if (this.host.func_204231_K()) {
            this.host.travelSwimming(new Vec3d(moveStrafe, 0.0, moveForward));
        } else if (this.host.lavaContact()) {
            this.host.travelSwimming(new Vec3d(moveStrafe, 0.0, moveForward));
        } else {
            this.host.travelFlying(new Vec3d(moveStrafe, 0.0, moveForward));
        }
        this.host.updateLimbSwing();
    }

    protected void adjustRotationToWaypoint() {
        double distX = (double)this.targetPosition.func_177958_n() - this.host.field_70165_t;
        double distZ = (double)this.targetPosition.func_177952_p() - this.host.field_70161_v;
        float fullAngle = (float)(Math.atan2(distZ, distX) * 180.0 / Math.PI);
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        if (angle > 30.0f) {
            angle = 30.0f;
        }
        if (angle < -30.0f) {
            angle = -30.0f;
        }
        this.host.field_70761_aq = this.host.field_70177_z += angle;
    }

    public void adjustRotationToTarget(BlockPos target) {
        double distX = (double)target.func_177958_n() - this.host.field_70165_t;
        double distZ = (double)target.func_177952_p() - this.host.field_70161_v;
        float fullAngle = (float)(Math.atan2(distZ, distX) * 180.0 / Math.PI) - 90.0f;
        float angle = MathHelper.func_76142_g((float)(fullAngle - this.host.field_70177_z));
        this.host.field_70177_z += angle;
    }
}

