/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class FindGroupAttackTargetGoal
extends FindAttackTargetGoal {
    public FindGroupAttackTargetGoal(BaseCreatureEntity setHost) {
        super(setHost);
    }

    @Override
    public FindGroupAttackTargetGoal setCheckSight(boolean bool) {
        this.checkSight = bool;
        return this;
    }

    @Override
    public FindGroupAttackTargetGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    @Override
    public FindGroupAttackTargetGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    @Override
    public FindGroupAttackTargetGoal setRange(double range) {
        this.targetingRange = range;
        return this;
    }

    @Override
    public FindGroupAttackTargetGoal setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    @Override
    public FindGroupAttackTargetGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        if (!this.tameTargeting && this.host.isTamed()) {
            return false;
        }
        boolean shouldFlee = false;
        boolean shouldAttack = false;
        boolean shouldPackAttack = false;
        for (CreatureGroup group : this.host.creatureInfo.getGroups()) {
            if (group.shouldFlee((Entity)target)) {
                shouldFlee = true;
            }
            if (group.shouldHunt((Entity)target)) {
                shouldAttack = true;
            }
            if (!group.shouldPackHunt((Entity)target)) continue;
            shouldPackAttack = true;
        }
        if (!(!shouldFlee || shouldPackAttack && this.host.isInPack())) {
            return false;
        }
        if (!(shouldAttack || shouldPackAttack && this.host.isInPack())) {
            return false;
        }
        if (!this.host.func_213358_a(target.func_200600_R())) {
            return false;
        }
        if (!this.host.func_213336_c(target)) {
            return false;
        }
        return this.host.rollAttackTargetChance(target);
    }

    @Override
    public LivingEntity getNewTarget(double rangeX, double rangeY, double rangeZ) {
        if (this.targetPlayers) {
            LivingEntity newTarget = null;
            try {
                List players = this.host.func_130014_f_().func_217369_A();
                if (players.isEmpty()) {
                    return null;
                }
                ArrayList<PlayerEntity> possibleTargets = new ArrayList<PlayerEntity>();
                for (PlayerEntity player : players) {
                    if (!this.isValidTarget((LivingEntity)player)) continue;
                    possibleTargets.add(player);
                }
                if (possibleTargets.isEmpty()) {
                    return null;
                }
                Collections.sort(possibleTargets, this.nearestSorter);
                newTarget = (LivingEntity)possibleTargets.get(0);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when player target selecting, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
            if (newTarget != null) {
                return newTarget;
            }
        }
        if (this.host.updateTick % 40L == 0L) {
            return super.getNewTarget(rangeX, rangeY, rangeZ);
        }
        return null;
    }
}

