/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.targeting;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.targeting.TargetingGoal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;

public class FindAttackTargetGoal
extends TargetingGoal {
    private List<EntityType> targetTypes = new ArrayList<EntityType>();
    protected boolean targetPlayers;
    private boolean requirePack = false;
    protected boolean tameTargeting = false;

    public FindAttackTargetGoal(BaseCreatureEntity setHost) {
        super(setHost);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public FindAttackTargetGoal setCheckSight(boolean bool) {
        this.checkSight = bool;
        return this;
    }

    public FindAttackTargetGoal addTargets(EntityType ... targets) {
        this.targetTypes.addAll(Arrays.asList(targets));
        for (EntityType targetType : targets) {
            this.host.setHostileTo(targetType);
            if (targetType != EntityType.field_200729_aH) continue;
            this.targetPlayers = true;
        }
        return this;
    }

    public FindAttackTargetGoal setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public FindAttackTargetGoal setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public FindAttackTargetGoal setRange(double range) {
        this.targetingRange = range;
        return this;
    }

    public FindAttackTargetGoal setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    public FindAttackTargetGoal setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public FindAttackTargetGoal requiresPack() {
        this.requirePack = true;
        return this;
    }

    @Override
    protected LivingEntity getTarget() {
        return this.host.func_70638_az();
    }

    @Override
    protected void setTarget(LivingEntity newTarget) {
        this.host.func_70624_b(newTarget);
    }

    @Override
    protected boolean isValidTarget(LivingEntity target) {
        if (this.targetTypes.size() > 0 && !this.targetTypes.contains(target.func_200600_R())) {
            return false;
        }
        if (!this.tameTargeting && this.host.isTamed()) {
            return false;
        }
        if (!this.host.rollAttackTargetChance(target)) {
            return false;
        }
        if (!this.host.func_213358_a(target.func_200600_R())) {
            return false;
        }
        if (!this.host.func_213336_c(target)) {
            return false;
        }
        return !this.requirePack || this.host.isInPack();
    }

    public boolean func_75250_a() {
        if (!this.host.func_213398_dR() || this.host.hasFixateTarget()) {
            return false;
        }
        if (this.targetPlayers ? this.host.updateTick % 10L != 0L : this.host.updateTick % 40L != 0L) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0 + (double)this.host.func_213302_cg();
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        if (this.callForHelp) {
            this.callNearbyForHelp();
        }
        return this.target != null;
    }

    @Override
    public LivingEntity getNewTarget(double rangeX, double rangeY, double rangeZ) {
        if (this.targetPlayers) {
            LivingEntity newTarget = null;
            try {
                List players = this.host.func_130014_f_().func_217369_A();
                if (players.isEmpty()) {
                    return null;
                }
                ArrayList<PlayerEntity> possibleTargets = new ArrayList<PlayerEntity>();
                for (PlayerEntity player : players) {
                    if (!this.isValidTarget((LivingEntity)player)) continue;
                    possibleTargets.add(player);
                }
                if (possibleTargets.isEmpty()) {
                    return null;
                }
                Collections.sort(possibleTargets, this.nearestSorter);
                newTarget = (LivingEntity)possibleTargets.get(0);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "An exception occurred when player target selecting, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
            if (newTarget != null || this.targetTypes.size() == 1) {
                return newTarget;
            }
        }
        if (this.host.updateTick % 40L == 0L) {
            return super.getNewTarget(rangeX, rangeY, rangeZ);
        }
        return null;
    }
}

