/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.block.building.BlockVeswax;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConba;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByHomeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;

public class EntityVespidQueen
extends AgeableCreatureEntity
implements IMob {
    public boolean inHiveCache = false;
    private int hiveCheckCacheTime = 0;
    public List<HiveExposedCoordinates> hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
    private int hiveExposedBlockCacheTime = 0;
    private int vespidQueenSwarmLimit = 10;
    private boolean vespidHiveBuilding = true;

    public EntityVespidQueen(EntityType<? extends EntityVespidQueen> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.solidCollision = true;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.field_70138_W = 1.0f;
        this.setAttackCooldownMax(10);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex, (Goal)new StayByHomeGoal(this));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindAttackTargetGoal(this).addTargets(this.func_200600_R()));
        EntityType<? extends LivingEntity> conbaType = CreatureManager.getInstance().getEntityType("conba");
        if (conbaType != null) {
            this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindAttackTargetGoal(this).addTargets(conbaType));
        }
    }

    @Override
    public boolean rollWanderChance() {
        return this.func_70681_au().nextDouble() <= 8.0E-4;
    }

    @Override
    public boolean isPersistant() {
        if (this.hasHome() && this.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.vespidHiveBuilding) {
            --this.hiveCheckCacheTime;
            if (this.hiveCheckCacheTime < 0) {
                this.hiveCheckCacheTime = 0;
            }
            --this.hiveExposedBlockCacheTime;
            if (this.hiveExposedBlockCacheTime < 0) {
                this.hiveExposedBlockCacheTime = 0;
            }
            if (!this.func_130014_f_().field_72995_K && !this.hasHome() && this.hiveFoundationsSet()) {
                this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 16.0f);
            }
            if (!this.func_130014_f_().field_72995_K && this.hiveFoundationsSet() && this.field_70173_aa % 60 == 0) {
                this.allyUpdate();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    public void allyUpdate() {
        LivingEntity minion;
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.vespidQueenSwarmLimit > 0 && this.nearbyCreatureCount(CreatureManager.getInstance().getCreature("vespid").getEntityType(), 32.0) < this.vespidQueenSwarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.05f && (minion = this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f))) instanceof AgeableCreatureEntity) {
            ((AgeableCreatureEntity)minion).setGrowingAge(((AgeableCreatureEntity)minion).growthTime);
        }
    }

    public LivingEntity spawnAlly(double x, double y, double z) {
        LivingEntity minion = CreatureManager.getInstance().getCreature("vespid").createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)minion).applySubspecies(this.getSubspeciesIndex());
        }
        this.func_130014_f_().func_217376_c((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        return minion;
    }

    public BlockPos getHivePosition() {
        if (this.hasHome()) {
            return this.func_213384_dI();
        }
        return this.func_180425_c();
    }

    public boolean hiveFoundationsSet() {
        return this.hiveFoundationsSet(false);
    }

    public boolean hiveFoundationsSet(boolean clearCache) {
        if (clearCache || this.hiveCheckCacheTime <= 0) {
            this.hiveCheckCacheTime = 100;
            if (!this.doesHiveHaveXPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveXNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZNegative()) {
                this.inHiveCache = false;
                return false;
            }
            this.inHiveCache = true;
            return true;
        }
        return this.inHiveCache;
    }

    public boolean isHiveBlock(BlockPos searchPos) {
        return this.isHiveWall(searchPos) || this.isHiveFloor(searchPos);
    }

    public boolean isHiveWall(BlockPos searchPos) {
        BlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("veswax");
    }

    public boolean isHiveFloor(BlockPos searchPos) {
        BlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("propolis");
    }

    public boolean doesHiveHaveXPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int x = hivePos.func_177958_n(); x <= hivePos.func_177958_n() + 28; ++x) {
            if (!this.isHiveWall(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveXNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int x = hivePos.func_177958_n(); x >= hivePos.func_177958_n() - 28; --x) {
            if (!this.isHiveWall(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int y = hivePos.func_177956_o(); y <= hivePos.func_177956_o() + 28; ++y) {
            if (!this.isHiveFloor(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int y = hivePos.func_177956_o(); y >= hivePos.func_177956_o() - 28; --y) {
            if (!this.isHiveFloor(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int z = hivePos.func_177952_p(); z <= hivePos.func_177952_p() + 28; ++z) {
            if (!this.isHiveWall(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int z = hivePos.func_177952_p(); z >= hivePos.func_177952_p() - 28; --z) {
            if (!this.isHiveWall(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) continue;
            return true;
        }
        return false;
    }

    public List<HiveExposedCoordinates> getHiveExposureBlocks() {
        if (this.hiveExposedBlockCacheTime <= 0) {
            this.hiveExposedBlockCacheTime = 200;
            this.hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
            BlockPos hivePos = this.getHivePosition();
            int hiveMax = 28;
            for (int x = hivePos.func_177958_n() - hiveMax; x <= hivePos.func_177958_n() + hiveMax; ++x) {
                for (int y = hivePos.func_177956_o() - hiveMax; y <= hivePos.func_177956_o() + hiveMax; ++y) {
                    for (int z = hivePos.func_177952_p() - hiveMax; z <= hivePos.func_177952_p() + hiveMax; ++z) {
                        BlockPos checkPos = new BlockPos(x, y, z);
                        if (!this.isHiveBlock(checkPos)) continue;
                        BlockState state = this.func_130014_f_().func_180495_p(checkPos);
                        Block block = state.func_177230_c();
                        int orientationMeta = (Integer)state.func_177229_b((IProperty)BlockVeswax.AGE) % 8;
                        Direction facing = Direction.func_82600_a((int)orientationMeta);
                        if (facing.func_82601_c() == 0) {
                            if (!this.isHiveBlock(checkPos.func_177982_a(-1, 0, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(-1, 0, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(-1, 0, 0), orientationMeta));
                            }
                            if (!this.isHiveBlock(checkPos.func_177982_a(1, 0, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(1, 0, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(1, 0, 0), orientationMeta));
                            }
                        }
                        if (facing.func_96559_d() == 0) {
                            if (!this.isHiveBlock(checkPos.func_177982_a(0, -1, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, -1, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, -1, 0), orientationMeta));
                            }
                            if (!this.isHiveBlock(checkPos.func_177982_a(0, 1, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, 1, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 1, 0), orientationMeta));
                            }
                        }
                        if (facing.func_82599_e() != 0) continue;
                        if (!this.isHiveBlock(checkPos.func_177982_a(0, 0, -1)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, 0, -1))) {
                            this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 0, -1), orientationMeta));
                        }
                        if (this.isHiveBlock(checkPos.func_177982_a(0, 0, 1)) || !this.canPlaceBlockAt(checkPos.func_177982_a(0, 0, 1))) continue;
                        this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 0, 1), orientationMeta));
                    }
                }
            }
        }
        return this.hiveExposedBlocks;
    }

    public boolean canPlaceBlockAt(BlockPos pos) {
        BlockState targetState = this.func_130014_f_().func_180495_p(pos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock == null) {
            return false;
        }
        if (targetBlock == Blocks.field_150350_a) {
            return true;
        }
        return targetState.func_185904_a() == Material.field_151586_h || targetState.func_185904_a() == Material.field_151587_i;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityConba) {
            ((EntityConba)target).vespidInfection = true;
            return true;
        }
        return true;
    }

    @Override
    public boolean func_213336_c(LivingEntity targetEntity) {
        if (targetEntity instanceof EntityConba && ((EntityConba)targetEntity).vespidInfection) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this)) {
            return false;
        }
        return super.func_213336_c(targetEntity);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    public class HiveExposedCoordinates {
        public Block block;
        public BlockPos pos;
        public int orientationMeta;

        public HiveExposedCoordinates(Block block, BlockPos pos, int orientationMeta) {
            this.block = block;
            this.pos = pos;
            this.orientationMeta = orientationMeta;
        }
    }
}

