/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityCrystalShard;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityVapula
extends TameableCreatureEntity
implements IMob {
    public int vapulaBlockBreakRadius = 0;
    public float fireDamageAbsorbed = 0.0f;

    public EntityVapula(EntityType<? extends EntityVapula> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.attackPhaseMax = (byte)8;
        this.setAttackCooldownMax(60);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false).setMaxChaseDistanceSq(3.0f));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.75).setRange(18.0f).setMinChaseDistance(10.0f).setCheckSight(false));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
            if (this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) && this.vapulaBlockBreakRadius > -1 && !this.isTamed()) {
                this.destroyArea((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10.0f, true, this.vapulaBlockBreakRadius);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150484_ah.func_176223_P()), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof SilverfishEntity) {
            return 4.0f;
        }
        return super.getAISpeedModifier();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof SilverfishEntity) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityCrystalShard.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        this.nextAttackPhase();
        super.attackRanged(target, range);
    }

    @Override
    public int getRangedCooldown() {
        if (this.getAttackPhase() < 7) {
            return super.getRangedCooldown() / 24;
        }
        return super.getRangedCooldown();
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            LivingEntity entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof LivingEntity && !(entityLiving = (LivingEntity)damageSrc.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(Hand.MAIN_HAND);
            }
            if (ObjectLists.isPickaxe(heldItem)) {
                return 3.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        if (source.func_76347_k()) {
            this.fireDamageAbsorbed += damage;
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }
}

