/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class EntityTremor
extends TameableCreatureEntity
implements IMob {
    private AttackMeleeGoal meleeAttackAI;
    public int tremorExplosionStrength = 1;

    public EntityTremor(EntityType<? extends EntityTremor> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.getSubspeciesIndex() == 3 && !this.isPetType("familiar") && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.func_70681_au().nextInt(20) == 0) {
            if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
            } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
            } else {
                this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        Explosion.Mode damageTerrain;
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        int explosionStrength = Math.max(1, this.tremorExplosionStrength);
        Explosion.Mode mode = damageTerrain = this.tremorExplosionStrength > 0 && this.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
        if (this.isPetType("familiar")) {
            explosionStrength = 1;
            damageTerrain = Explosion.Mode.NONE;
        }
        this.func_130014_f_().func_217385_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)explosionStrength, damageTerrain);
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (source.func_94541_c()) {
            this.func_70691_i(damage);
            return false;
        }
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof WitherEntity) {
            return false;
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean func_70687_e(EffectInstance effectInstance) {
        if (effectInstance.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean canBeTargetedBy(LivingEntity entity) {
        if (entity instanceof WitherEntity) {
            return false;
        }
        return super.canBeTargetedBy(entity);
    }
}

