/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityRoa
extends RideableCreatureEntity
implements IMob {
    WanderGoal wanderAI;
    protected int whirlpoolRange = 6;
    protected int whirlpoolEnergy = 0;
    protected int whirlpoolEnergyMax = 100;
    protected boolean whirlpoolRecharging = true;
    protected int mountedWhirlpool = 0;

    public EntityRoa(EntityType<? extends EntityRoa> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.spawnsOnLand = false;
        this.spawnsInWater = true;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.0;
        this.canGrow = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.whirlpoolRecharging && ++this.whirlpoolEnergy >= this.whirlpoolEnergyMax) {
                this.whirlpoolRecharging = false;
            }
            this.whirlpoolEnergy = Math.min(this.whirlpoolEnergy, this.whirlpoolEnergyMax);
            if (this.canWhirlpool()) {
                for (Entity entity : this.getNearbyEntities(Entity.class, null, this.whirlpoolRange)) {
                    LivingEntity entityLivingBase;
                    if (entity == this || entity.getClass() == ((Object)((Object)this)).getClass() || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity instanceof LivingEntity && ((entityLivingBase = (LivingEntity)entity).func_70644_a((Effect)ObjectManager.getEffect("weight")) || !this.func_213336_c(entityLivingBase) || !entity.func_70090_H() && !this.spawnEventType.equalsIgnoreCase("sharknado"))) continue;
                    ServerPlayerEntity player = null;
                    if (entity instanceof ServerPlayerEntity) {
                        player = (ServerPlayerEntity)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.field_70165_t - entity.field_70165_t;
                    double zDist = this.field_70161_v - entity.field_70161_v;
                    double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                    double factor = 0.1;
                    double motionCap = 10.0;
                    if (entity.func_213322_ci().func_82615_a() < motionCap && entity.func_213322_ci().func_82615_a() > -motionCap && entity.func_213322_ci().func_82616_c() < motionCap && entity.func_213322_ci().func_82616_c() > -motionCap) {
                        entity.func_70024_g(xDist / xzDist * factor + entity.func_213322_ci().func_82615_a() * factor, 0.0, zDist / xzDist * factor + entity.func_213322_ci().func_82616_c() * factor);
                    }
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                }
                if (--this.whirlpoolEnergy <= 0) {
                    this.whirlpoolRecharging = true;
                }
            }
        }
        if (this.mountedWhirlpool > 0) {
            --this.mountedWhirlpool;
        }
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        rider.func_195064_c(new EffectInstance(Effects.field_76427_o, 105, 1));
        super.riderEffects(rider);
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canWhirlpool();
    }

    public boolean canWhirlpool() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        if ("sharknado".equals(this.spawnEventType)) {
            return true;
        }
        if (!this.func_70090_H()) {
            return false;
        }
        if (this.func_184179_bs() != null && this.mountedWhirlpool > 0) {
            return true;
        }
        return !this.whirlpoolRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.whirlpoolRange * 3);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block == Blocks.field_150355_j) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_72896_J() && this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.waterContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean canWalk() {
        return false;
    }

    @Override
    public boolean isFlying() {
        if ("sharknado".equals(this.spawnEventType)) {
            return true;
        }
        return super.isFlying();
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.25;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAir() {
        return "sharknado".equals(this.spawnEventType);
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.applyStaminaCost();
        this.mountedWhirlpool = 20;
    }

    @Override
    public float getStaminaCost() {
        return 1.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 0;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 2.0f;
    }

    @Override
    public void onDismounted(Entity entity) {
        super.onDismounted(entity);
        if (entity != null && entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76427_o, 100, 1));
        }
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cookedmeat", testStack) || ObjectLists.inItemList("cookedfish", testStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

