/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.projectile.EntityFaeBolt;
import com.lycanitesmobs.core.entity.projectile.EntityLifeDrain;
import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityNymph
extends TameableCreatureEntity {
    public int healingRate = 20;
    private int farmingTick = 0;
    EntityLifeDrain projectile = null;

    public EntityNymph(EntityType<? extends EntityNymph> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223222_a_;
        this.hasAttackSound = false;
        this.fleeHealthPercent = 1.0f;
        this.isAggressiveByDefault = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.healingRate > 0 && !this.isPetType("familiar") && this.updateTick % (long)this.healingRate == 0L) {
                List<LivingEntity> aoeTargets = this.getNearbyEntities(LivingEntity.class, null, 4.0);
                for (LivingEntity entityObj : aoeTargets) {
                    LivingEntity target = entityObj;
                    if (target == this || target instanceof EntityNymph || target == this.func_70638_az() || target == this.getAvoidTarget()) continue;
                    target.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 0));
                }
            }
            if (this.hasAvoidTarget()) {
                if (this.updateTick % (long)this.getRangedCooldown() == 0L) {
                    this.attackRanged((Entity)this.getAvoidTarget(), this.func_70032_d((Entity)this.getAvoidTarget()));
                }
            } else if (this.hasAttackTarget() && this.updateTick % (long)this.getRangedCooldown() == 0L) {
                this.attackRanged((Entity)this.func_70638_az(), this.func_70032_d((Entity)this.func_70638_az()));
            }
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityFaeBolt.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.75f, 1.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }
}

