/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConcapedeHead;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityConcapedeSegment
extends AgeableCreatureEntity {
    UUID parentUUID = null;

    public EntityConcapedeSegment(EntityType<? extends EntityConcapedeSegment> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.hasStepSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    @Override
    public boolean environmentSpawnCheck(World world, BlockPos pos) {
        if (this.getNearbyEntities(EntityConcapedeHead.class, null, CreatureManager.getInstance().spawnConfig.spawnLimitRange).size() <= 0) {
            return false;
        }
        return super.environmentSpawnCheck(world, pos);
    }

    @Override
    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.hasParent()) {
            this.subspecies = this.creatureInfo.getRandomSubspecies((LivingEntity)this);
            if (this.subspecies != null) {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + this.subspecies.getTitle());
            } else {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
            }
        }
        if (this.hasParent() && this.getParentTarget() instanceof BaseCreatureEntity) {
            this.applySubspecies(((BaseCreatureEntity)this.getParentTarget()).getSubspeciesIndex());
        }
    }

    @Override
    protected boolean canDespawnNaturally() {
        if (!super.canDespawnNaturally()) {
            return false;
        }
        return !this.hasParent();
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && !this.hasParent() && this.parentUUID != null) {
            double range = 64.0;
            List connections = this.func_130014_f_().func_217357_a(AgeableCreatureEntity.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (AgeableCreatureEntity possibleConnection : connections) {
                if (possibleConnection == this || !possibleConnection.func_110124_au().equals(this.parentUUID)) continue;
                this.setParentTarget((LivingEntity)possibleConnection);
                break;
            }
            this.parentUUID = null;
        }
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.hasMaster() && !this.getMasterTarget().func_70089_S()) {
                this.setMasterTarget(null);
            }
            if (this.hasParent() && !this.getParentTarget().func_70089_S()) {
                this.setParentTarget(null);
            }
            if (this.hasParent()) {
                this.func_70625_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                double segmentDistance = 0.5;
                Vec3d pos = this.getParentTarget() instanceof BaseCreatureEntity ? ((BaseCreatureEntity)this.getParentTarget()).getFacingPositionDouble(this.getParentTarget().field_70165_t, this.getParentTarget().field_70163_u, this.getParentTarget().field_70161_v, -0.25, 0.0) : new Vec3d(this.getParentTarget().field_70165_t, this.getParentTarget().field_70163_u, this.getParentTarget().field_70161_v);
                if (this.field_70165_t - pos.field_72450_a > segmentDistance) {
                    this.field_70165_t = pos.field_72450_a + segmentDistance;
                } else if (this.field_70165_t - pos.field_72450_a < -segmentDistance) {
                    this.field_70165_t = pos.field_72450_a - segmentDistance;
                }
                if (this.field_70163_u - pos.field_72448_b > segmentDistance) {
                    this.field_70163_u = pos.field_72448_b + segmentDistance;
                } else if (this.field_70163_u - pos.field_72448_b < -(segmentDistance / 2.0)) {
                    this.field_70163_u = pos.field_72448_b;
                }
                if (this.field_70161_v - pos.field_72449_c > segmentDistance) {
                    this.field_70161_v = pos.field_72449_c + segmentDistance;
                } else if (this.field_70161_v - pos.field_72449_c < -segmentDistance) {
                    this.field_70161_v = pos.field_72449_c - segmentDistance;
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.getGrowingAge() <= 0) {
            this.setGrowingAge(-this.growthTime);
        }
    }

    @Override
    public void setGrowingAge(int age) {
        if (this.hasParent()) {
            age = -this.growthTime;
        }
        super.setGrowingAge(age);
        if (age == 0 && !this.func_130014_f_().field_72995_K) {
            EntityConcapedeHead concapedeHead = (EntityConcapedeHead)CreatureManager.getInstance().getCreature("concapede").createEntity(this.func_130014_f_());
            concapedeHead.func_82149_j((Entity)this);
            concapedeHead.firstSpawn = false;
            concapedeHead.setGrowingAge(-this.growthTime / 4);
            this.func_130014_f_().func_217376_c((Entity)concapedeHead);
            if (this.hasMaster() && this.getMasterTarget() instanceof EntityConcapedeSegment) {
                ((EntityConcapedeSegment)this.getMasterTarget()).setParentTarget((LivingEntity)concapedeHead);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean shouldFollowParent() {
        return true;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return !this.hasParent();
    }

    @Override
    public double getFallingMod() {
        if (this.func_130014_f_().field_72995_K) {
            return 0.0;
        }
        if (this.hasParent() && this.getParentTarget().field_70163_u > this.field_70163_u) {
            return 0.0;
        }
        return super.getFallingMod();
    }

    @Override
    public void setParentTarget(LivingEntity setTarget) {
        if (setTarget instanceof EntityConcapedeSegment || setTarget instanceof EntityConcapedeHead) {
            ((BaseCreatureEntity)setTarget).setMasterTarget((LivingEntity)this);
        }
        super.setParentTarget(setTarget);
    }

    @Override
    public boolean renderSubspeciesNameTag() {
        return !this.hasParent();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isInvulnerableTo(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isInvulnerableTo(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return null;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Vegetables", testStack);
    }

    @Override
    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.setGrowingAge(0);
        return true;
    }

    @Override
    public boolean canBreed() {
        return !this.hasParent();
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ParentUUIDMost") && nbtTagCompound.func_74764_b("ParentUUIDLeast")) {
            this.parentUUID = new UUID(nbtTagCompound.func_74763_f("ParentUUIDMost"), nbtTagCompound.func_74763_f("ParentUUIDLeast"));
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        if (this.getParentTarget() != null) {
            nbtTagCompound.func_74772_a("ParentUUIDMost", this.getParentTarget().func_110124_au().getMostSignificantBits());
            nbtTagCompound.func_74772_a("ParentUUIDLeast", this.getParentTarget().func_110124_au().getLeastSignificantBits());
        }
        super.func_213281_b(nbtTagCompound);
    }
}

