/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConcapedeSegment;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityConcapedeHead
extends AgeableCreatureEntity {
    public static int CONCAPEDE_SIZE_MAX = 10;

    public EntityConcapedeHead(EntityType<? extends EntityConcapedeHead> entityType, World world) {
        super((EntityType<? extends AgeableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223224_c_;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new TemptGoal(this).setItemList("vegetables"));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void onFirstSpawn() {
        if (!this.func_130014_f_().field_72995_K && !this.hasMaster()) {
            this.setGrowingAge(-this.growthTime / 4);
            int segmentCount = this.func_70681_au().nextInt(CONCAPEDE_SIZE_MAX);
            AgeableCreatureEntity parentSegment = this;
            for (int segment = 0; segment < segmentCount; ++segment) {
                EntityConcapedeSegment segmentEntity = (EntityConcapedeSegment)CreatureManager.getInstance().getCreature("concapedesegment").createEntity(parentSegment.func_130014_f_());
                segmentEntity.func_70012_b(parentSegment.field_70165_t, parentSegment.field_70163_u, parentSegment.field_70161_v, 0.0f, 0.0f);
                segmentEntity.setParentTarget((LivingEntity)parentSegment);
                parentSegment.func_130014_f_().func_217376_c((Entity)segmentEntity);
                parentSegment = segmentEntity;
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void setGrowingAge(int age) {
        if (!this.firstSpawn && age == 0 && CreatureManager.getInstance().getCreature("ConcapedeSegment") != null && !this.func_130014_f_().field_72995_K) {
            age = -(this.growthTime / 4);
            BaseCreatureEntity parentSegment = this;
            boolean lastSegment = false;
            int size = 0;
            while (!lastSegment) {
                ++size;
                if (parentSegment.hasMaster() && parentSegment.getMasterTarget() instanceof BaseCreatureEntity) {
                    parentSegment = (BaseCreatureEntity)parentSegment.getMasterTarget();
                    continue;
                }
                lastSegment = true;
            }
            if (size < CONCAPEDE_SIZE_MAX) {
                EntityConcapedeSegment segmentEntity = (EntityConcapedeSegment)CreatureManager.getInstance().getCreature("concapedesegment").createEntity(parentSegment.func_130014_f_());
                segmentEntity.func_70012_b(parentSegment.field_70165_t, parentSegment.field_70163_u, parentSegment.field_70161_v, 0.0f, 0.0f);
                parentSegment.func_130014_f_().func_217376_c((Entity)segmentEntity);
                segmentEntity.setParentTarget((LivingEntity)parentSegment);
            }
        }
        super.setGrowingAge(age);
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        BlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityConcapedeSegment) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public boolean func_213398_dR() {
        if (this.isInLove()) {
            return false;
        }
        this.func_130014_f_();
        if (this.func_130014_f_().func_72935_r()) {
            return this.testLightLevel() < 2;
        }
        return super.func_213398_dR();
    }

    @Override
    public boolean isProtective(Entity entity) {
        if (this.isInLove()) {
            return false;
        }
        if (entity instanceof EntityConcapedeSegment) {
            for (BaseCreatureEntity checkSegment = this; checkSegment != null; checkSegment = (BaseCreatureEntity)checkSegment.getMasterTarget()) {
                if (checkSegment == entity) {
                    return true;
                }
                if (!checkSegment.hasMaster()) break;
            }
        }
        return false;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return null;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Vegetables", testStack);
    }

    @Override
    public boolean canBreed() {
        return this.getGrowingAge() >= 0;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }
}

