/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAsmodeus;
import com.lycanitesmobs.core.entity.creature.EntityAstaroth;
import com.lycanitesmobs.core.entity.creature.EntityTrite;
import com.lycanitesmobs.core.entity.creature.EntityWraith;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.entity.projectile.EntityDemonicBlast;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityCacodemon
extends RideableCreatureEntity {
    public boolean cacodemonGreifing = true;

    public EntityCacodemon(EntityType<? extends EntityCacodemon> entityType, World world) {
        super((EntityType<? extends RideableCreatureEntity>)entityType, world);
        this.attribute = CreatureAttribute.field_223223_b_;
        this.hasAttackSound = false;
        this.setAttackCooldownMax(20);
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (Goal)new AttackRangedGoal(this).setSpeed(0.25).setRange(40.0f).setMinChaseDistance(10.0f).setLongMemory(false));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindAttackTargetGoal(this).addTargets(EntityType.field_200811_y));
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && this.getSubspeciesIndex() == 3 && this.hasAttackTarget() && this.field_70173_aa % 20 == 0) {
            this.allyUpdate();
        }
        super.func_70636_d();
    }

    @Override
    public void riderEffects(LivingEntity rider) {
        if (rider.func_70644_a(Effects.field_82731_v)) {
            rider.func_195063_d(Effects.field_82731_v);
        }
        if (rider.func_70027_ad()) {
            rider.func_70066_B();
        }
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (CreatureManager.getInstance().getCreature((String)"wraith").enabled && this.nearbyCreatureCount(CreatureManager.getInstance().getCreature("wraith").getEntityType(), 64.0) < 10 && (random = this.field_70146_Z.nextFloat()) <= 0.1f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        EntityWraith minion = (EntityWraith)CreatureManager.getInstance().getCreature("wraith").createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        minion.setMinion(true);
        minion.setMasterTarget((LivingEntity)this);
        this.func_130014_f_().func_217376_c((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        minion.setSizeScale(this.sizeScale);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        if (target instanceof EntityTrite || target instanceof EntityAstaroth || target instanceof EntityAsmodeus || target instanceof EntityWraith) {
            return false;
        }
        return super.func_213336_c(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile(EntityDemonicBlast.class, target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.6f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isInvulnerableTo(Entity entity) {
        if (entity instanceof EntityCacodemon) {
            return false;
        }
        return super.isInvulnerableTo(entity);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)Pose.STANDING).field_220316_b * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        if (rider instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)rider;
            EntityDemonicBlast projectile = new EntityDemonicBlast(ProjectileManager.getInstance().oldProjectileTypes.get(EntityDemonicBlast.class), this.func_130014_f_(), (LivingEntity)player);
            this.func_130014_f_().func_217376_c((Entity)projectile);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.triggerAttackCooldown();
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 10.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 40;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public float func_70013_c() {
        if (this.isAttackOnCooldown()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        if (this.isAttackOnCooldown()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }
}

