/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.targeting.CopyRiderAttackTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeRiderGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RideableCreatureEntity
extends TameableCreatureEntity {
    public Entity lastRiddenByEntity = null;
    public boolean mountJumping = false;
    public float jumpPower = 0.0f;
    public boolean abilityToggled = false;
    public boolean inventoryToggled = false;

    public RideableCreatureEntity(EntityType<? extends RideableCreatureEntity> entityType, World world) {
        super((EntityType<? extends TameableCreatureEntity>)entityType, world);
        this.hasJumpSound = true;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (Goal)new PlayerControlGoal(this));
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(this.nextReactTargetIndex++, (Goal)new RevengeRiderGoal(this));
        this.field_70715_bh.func_75776_a(this.nextReactTargetIndex++, (Goal)new CopyRiderAttackTargetGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.lastRiddenByEntity != this.func_184179_bs()) {
            if (this.lastRiddenByEntity != null) {
                this.onDismounted(this.lastRiddenByEntity);
            }
            this.lastRiddenByEntity = this.func_184179_bs();
        }
        if (this.hasRiderTarget()) {
            if (this.func_184179_bs() instanceof LivingEntity) {
                LivingEntity riderLiving = (LivingEntity)this.func_184179_bs();
                this.riderEffects(riderLiving);
                for (Object possibleEffect : riderLiving.func_70651_bq().toArray(new Object[0])) {
                    EffectInstance effectInstance;
                    if (!(possibleEffect instanceof EffectInstance) || this.func_70687_e(effectInstance = (EffectInstance)possibleEffect)) continue;
                    riderLiving.func_195063_d(effectInstance.func_188419_a());
                }
            }
        } else {
            this.abilityToggled = false;
            this.inventoryToggled = false;
        }
    }

    public void riderEffects(LivingEntity rider) {
        if (!rider.func_70648_aU() && this.func_70648_aU() && rider.func_70090_H()) {
            rider.func_70050_g(300);
        }
        for (EffectInstance effectInstance : rider.func_70651_bq().toArray(new EffectInstance[rider.func_70651_bq().size()])) {
            if (this.func_70687_e(effectInstance) || !ObjectLists.inEffectList("debuffs", effectInstance.func_188419_a())) continue;
            rider.func_195063_d(effectInstance.func_188419_a());
        }
    }

    public void mountAbility(Entity rider) {
    }

    public void onDismounted(Entity entity) {
        if (this.isSitting()) {
            int homeY = MathHelper.func_76128_c((double)this.field_70163_u);
            if (!this.isFlying()) {
                homeY = this.getGroundY(this.func_180425_c());
            }
            this.setHomePosition(MathHelper.func_76128_c((double)this.field_70165_t), homeY, MathHelper.func_76128_c((double)this.field_70161_v));
        }
    }

    @Override
    public boolean func_70104_M() {
        if (this.func_184179_bs() != null) {
            return false;
        }
        return super.func_70104_M();
    }

    @Override
    public boolean func_82171_bF() {
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        Entity entity = this.func_184179_bs();
        return entity == this.getOwner();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double zOffset = this.getMountedZOffset();
            if (zOffset == 0.0) {
                zOffset = 1.0E-5;
            }
            Vec3d mountOffset = this.getFacingPositionDouble(0.0, 0.0, 0.0, zOffset, this.field_70177_z);
            this.func_184179_bs().func_70107_b(this.field_70165_t + mountOffset.field_72450_a, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + mountOffset.field_72449_c);
        }
    }

    private void mount(Entity entity) {
        entity.field_70177_z = this.field_70177_z;
        entity.field_70125_A = this.field_70125_A;
        if (!this.func_130014_f_().field_72995_K) {
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public void func_213352_e(Vec3d direction) {
        if (!(this.isTamed() && this.hasSaddle() && this.hasRiderTarget() && this.func_184179_bs() instanceof LivingEntity && this.riderControl())) {
            super.func_213352_e(direction);
            return;
        }
        this.moveMountedWithHeading(direction.func_82615_a(), direction.func_82617_b(), direction.func_82616_c());
    }

    public void moveMountedWithHeading(double strafe, double up, double forward) {
        ExtendedPlayer playerExt;
        PlayerEntity player;
        if (this.func_184179_bs() instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = rider.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = rider.field_70702_br * 0.5f;
            forward = rider.field_191988_bg;
        }
        double verticalMotion = 0.0;
        if (this.func_70090_H() || this.func_180799_ab() || this.isFlying()) {
            if (this.func_184179_bs() instanceof PlayerEntity) {
                player = (PlayerEntity)this.func_184179_bs();
                playerExt = ExtendedPlayer.getForPlayer(player);
                verticalMotion = playerExt != null && playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.JUMP) ? this.creatureStats.getSpeed() * 20.0 : (player.field_70125_A > 0.0f && forward != 0.0 ? this.creatureStats.getSpeed() * 20.0 * (double)(-(player.field_70125_A / 90.0f)) : 0.0);
            }
        } else {
            PlayerEntity player2;
            ExtendedPlayer playerExt2;
            if (!this.isMountJumping() && this.func_184179_bs() instanceof PlayerEntity && (playerExt2 = ExtendedPlayer.getForPlayer(player2 = (PlayerEntity)this.func_184179_bs())) != null && playerExt2.isControlActive(ExtendedPlayer.CONTROL_ID.JUMP)) {
                this.startJumping();
            }
            if (this.getJumpPower() > 0.0f && !this.isMountJumping() && this.func_184186_bw()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.getMountJumpHeight() * (double)this.getJumpPower(), 0.0));
                if (this.func_70644_a(Effects.field_76430_j)) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f), 0.0));
                }
                this.setMountJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0) {
                    float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                }
                if (!this.func_130014_f_().field_72995_K) {
                    this.playJumpSound();
                }
                this.setJumpPower(0);
                ForgeHooks.onLivingJump((LivingEntity)this);
            }
            this.field_70747_aH = (float)((double)this.func_70689_ay() * this.getGlideScale());
        }
        if (this.func_184179_bs() instanceof PlayerEntity && (playerExt = ExtendedPlayer.getForPlayer(player = (PlayerEntity)this.func_184179_bs())) != null) {
            if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_ABILITY)) {
                this.mountAbility((Entity)player);
                this.abilityToggled = true;
            } else {
                this.abilityToggled = false;
            }
            if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_INVENTORY)) {
                if (!this.inventoryToggled) {
                    this.openGUI(player);
                }
                this.inventoryToggled = true;
            } else {
                this.inventoryToggled = false;
            }
        }
        if (this.func_184186_bw()) {
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            if (!this.useDirectNavigator()) {
                if (this.isFlying() && !this.func_70090_H() && !this.func_180799_ab()) {
                    this.func_213309_a(0.1f, new Vec3d(strafe, 0.0, forward));
                    this.func_213315_a(MoverType.SELF, new Vec3d(this.func_213322_ci().field_72450_a, verticalMotion / 16.0, this.func_213322_ci().field_72449_c));
                    this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.9f, (double)0.9f, (double)0.9f));
                } else if (this.func_70090_H() || this.func_180799_ab()) {
                    if (!this.isStrongSwimmer()) {
                        verticalMotion *= 0.25;
                        strafe *= 0.25;
                        forward *= 0.25;
                    }
                    this.func_213309_a(0.1f, new Vec3d(strafe, 0.0, forward));
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_72441_c(0.0, verticalMotion / 16.0, 0.0));
                    this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.9f, (double)0.9f, (double)0.9f));
                } else {
                    super.func_213352_e(new Vec3d(strafe, up, forward));
                }
            } else {
                this.directNavigator.flightMovement(strafe, forward);
            }
        }
        if (this.field_70122_E || this.func_70090_H() || this.func_180799_ab()) {
            this.setJumpPower(0);
            this.setMountJumping(false);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void startJumping() {
        this.setJumpPower();
    }

    public double getMountJumpHeight() {
        return 0.75;
    }

    public boolean isMountJumping() {
        return this.mountJumping;
    }

    public void setMountJumping(boolean set) {
        this.mountJumping = set;
    }

    public void setJumpPower(int power) {
        if (power < 0) {
            power = 0;
        }
        if (power > 99) {
            power = 99;
        }
        this.jumpPower = power < 90 ? 1.0f * ((float)power / 89.0f) : 1.0f + 1.0f * ((float)(power - 89) / 10.0f);
    }

    public void setJumpPower() {
        this.setJumpPower(89);
    }

    public float getJumpPower() {
        return this.jumpPower;
    }

    public double getGlideScale() {
        return 0.1f;
    }

    public boolean riderControl() {
        return true;
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(PlayerEntity player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        boolean mountingAllowed = CreatureManager.getInstance().config.mountingEnabled;
        if (mountingAllowed && this.isFlying()) {
            mountingAllowed = CreatureManager.getInstance().config.mountingFlightEnabled;
        }
        if (this.canBeMounted((Entity)player) && !player.func_70093_af() && !this.func_130014_f_().field_72995_K && mountingAllowed) {
            commands.put(BaseCreatureEntity.COMMAND_PIORITIES.MAIN.id, "Mount");
        }
        return commands;
    }

    @Override
    public void performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        if (command.equals("Mount")) {
            this.playMountSound();
            this.clearMovement();
            this.func_70624_b(null);
            this.mount((Entity)player);
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public Team func_96124_cp() {
        LivingEntity rider;
        if (this.hasRiderTarget() && (rider = this.getRider()) != null) {
            return rider.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    @Override
    public boolean func_184191_r(Entity target) {
        if (this.hasRiderTarget()) {
            LivingEntity rider = this.getRider();
            if (target == rider) {
                return true;
            }
            if (rider != null) {
                return rider.func_184191_r(target);
            }
        }
        return super.func_184191_r(target);
    }

    public boolean canBeMounted(Entity entity) {
        if (this.func_184179_bs() != null) {
            return false;
        }
        if (this.isTamed() && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player == this.getOwner()) {
                return this.hasSaddle() && !this.func_70631_g_();
            }
        } else if (!this.isTamed() && !(entity instanceof PlayerEntity)) {
            return !this.func_70631_g_();
        }
        return false;
    }

    public boolean hasSaddle() {
        ItemStack saddleStack = this.inventory.getEquipmentStack("saddle");
        return saddleStack != null && !saddleStack.func_190926_b();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        Entity entity = damageSource.func_76346_g();
        return this.func_184179_bs() != null && this.func_184215_y(entity) ? false : super.func_70097_a(damageSource, damage);
    }

    @Override
    public float getFallResistance() {
        return 2.0f;
    }

    public void playMountSound() {
        this.func_184185_a(ObjectManager.getSound(this.creatureInfo.getName() + "_mount"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }
}

