/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class RapidFireProjectileEntity
extends BaseProjectileEntity {
    public LivingEntity shootingEntity;
    private float projectileWidth = 0.2f;
    private float projectileHeight = 0.2f;
    private Class projectileClass;
    private ProjectileInfo projectileInfo;
    private int rapidTime = 100;
    private int rapidDelay = 5;
    public double offsetX = 0.0;
    public double offsetY = 0.0;
    public double offsetZ = 0.0;

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, World world) {
        super(entityType, world);
        this.field_70145_X = true;
    }

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, Class entityClass, World world, int setTime, int setDelay) {
        super(entityType, world);
        this.projectileClass = entityClass;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, Class entityClass, World world, double x, double y, double z, int setTime, int setDelay) {
        super(entityType, world, x, y, z);
        this.projectileClass = entityClass;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, Class entityClass, World world, LivingEntity entityLivingBase, int setTime, int setDelay) {
        super(entityType, world, entityLivingBase);
        this.projectileClass = entityClass;
        this.shootingEntity = entityLivingBase;
        this.offsetX = this.field_70165_t - entityLivingBase.field_70165_t;
        this.offsetY = this.field_70163_u - entityLivingBase.field_70163_u;
        this.offsetZ = this.field_70161_v - entityLivingBase.field_70161_v;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, ProjectileInfo projectileInfo, World world, double par2, double par4, double par6, int setTime, int setDelay) {
        super(entityType, world, par2, par4, par6);
        this.projectileInfo = projectileInfo;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public RapidFireProjectileEntity(EntityType<? extends BaseProjectileEntity> entityType, ProjectileInfo projectileInfo, World world, LivingEntity entityLivingBase, int setTime, int setDelay) {
        super(entityType, world, entityLivingBase);
        this.projectileInfo = projectileInfo;
        this.shootingEntity = entityLivingBase;
        this.offsetX = this.field_70165_t - entityLivingBase.field_70165_t;
        this.offsetY = this.field_70163_u - entityLivingBase.field_70163_u;
        this.offsetZ = this.field_70161_v - entityLivingBase.field_70161_v;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    @Override
    public void func_70071_h_() {
        if (this.shootingEntity != null) {
            this.field_70165_t = this.shootingEntity.field_70165_t + this.offsetX;
            this.field_70163_u = this.shootingEntity.field_70163_u + this.offsetY;
            this.field_70161_v = this.shootingEntity.field_70161_v + this.offsetZ;
        }
        if (this.rapidTime > 0) {
            if (this.projectileClass == null && this.projectileInfo == null) {
                this.rapidTime = 0;
                return;
            }
            if (this.rapidTime % this.rapidDelay == 0) {
                this.fireProjectile();
            }
            --this.rapidTime;
        } else if (this.func_70089_S()) {
            this.func_70106_y();
        }
    }

    public void addTime(int addTime) {
        this.rapidTime += addTime;
    }

    public void fireProjectile() {
        World world = this.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        try {
            BaseProjectileEntity projectile;
            if (this.shootingEntity == null) {
                if (this.projectileInfo != null) {
                    projectile = this.projectileInfo.createProjectile(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    projectile.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, (float)this.projectileInfo.velocity, 0.0f);
                } else {
                    projectile = ProjectileManager.getInstance().createOldProjectile(this.projectileClass, world, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    projectile.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, 1.0f, 1.0f);
                }
            } else {
                if (this.projectileInfo != null) {
                    projectile = this.projectileInfo.createProjectile(this.func_130014_f_(), this.shootingEntity);
                    projectile.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, (float)this.projectileInfo.velocity, 0.0f);
                } else {
                    projectile = ProjectileManager.getInstance().createOldProjectile(this.projectileClass, world, this.shootingEntity);
                    projectile.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, 1.0f, 1.0f);
                }
                if (projectile instanceof ThrowableEntity) {
                    ThrowableEntity entityThrowable = projectile;
                    entityThrowable.func_70107_b(this.shootingEntity.field_70165_t + this.offsetX, this.shootingEntity.field_70163_u + this.offsetY, this.shootingEntity.field_70161_v + this.offsetZ);
                }
            }
            if (projectile instanceof BaseProjectileEntity) {
                projectile.setProjectileScale(this.projectileScale);
            }
            world.func_217376_c((Entity)projectile);
        }
        catch (Exception e) {
            System.out.println("[WARNING] [LycanitesMobs] EntityRapidFire was unable to instantiate the given projectile class.");
            e.printStackTrace();
        }
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.shootingEntity != null) {
            this.offsetX = x - this.shootingEntity.field_70165_t;
            this.offsetY = y - this.shootingEntity.field_70163_u;
            this.offsetZ = z - this.shootingEntity.field_70161_v;
        }
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }
}

