/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSummoning;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PortalEntity
extends BaseProjectileEntity {
    private double targetX;
    private double targetY;
    private double targetZ;
    public int summonAmount = 0;
    public int summonTick = 0;
    public int summonTime = 100;
    public double portalRange = 32.0;
    public int summonDuration = 1200;
    public PlayerEntity shootingEntity;
    public EntityType summonType;
    public CreatureInfo creatureInfo;
    public ItemStaffSummoning portalItem;
    public UUID ownerUUID;
    public TileEntitySummoningPedestal summoningPedestal;
    protected static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(PortalEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public PortalEntity(EntityType<? extends PortalEntity> entityType, World world) {
        super(entityType, world);
        this.setStats();
    }

    public PortalEntity(EntityType<? extends PortalEntity> entityType, World world, PlayerEntity shooter, EntityType summonType, ItemStaffSummoning portalItem) {
        super(entityType, world, (LivingEntity)shooter);
        this.shootingEntity = shooter;
        this.summonType = summonType;
        this.portalItem = portalItem;
        this.setStats();
    }

    public PortalEntity(EntityType<? extends PortalEntity> entityType, World world, PlayerEntity shooter, CreatureInfo creatureInfo, ItemStaffSummoning portalItem) {
        super(entityType, world, (LivingEntity)shooter);
        this.shootingEntity = shooter;
        this.creatureInfo = creatureInfo;
        this.summonType = creatureInfo.getEntityType();
        this.portalItem = portalItem;
        this.setStats();
    }

    public PortalEntity(EntityType<? extends PortalEntity> entityType, World world, TileEntitySummoningPedestal summoningPedestal) {
        super(entityType, world);
        this.summoningPedestal = summoningPedestal;
        this.setStats();
        this.field_70165_t = (double)summoningPedestal.func_174877_v().func_177958_n() + 0.5;
        this.field_70163_u = (double)summoningPedestal.func_174877_v().func_177956_o() + 3.0;
        this.field_70161_v = (double)summoningPedestal.func_174877_v().func_177952_p() + 0.5;
    }

    public void setStats() {
        this.entityName = "summoningportal";
        this.setProjectileScale(6.0f);
        this.moveToTarget();
        this.textureOffsetY = -0.5f;
        this.animationFrameMax = 7;
        this.movement = false;
        this.waterProof = true;
        this.lavaProof = true;
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    @Override
    public void func_70071_h_() {
        ExtendedPlayer playerExt;
        if (this.shootingEntity != null || this.summoningPedestal != null) {
            this.projectileLife = 5;
        }
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.summoningPedestal != null) {
            this.shootingEntity = this.summoningPedestal.getPlayer();
            this.summonType = this.summoningPedestal.getSummonType();
            this.creatureInfo = this.summoningPedestal.getCreatureInfo();
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.shootingEntity != null) {
                this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(this.shootingEntity.func_110124_au()));
            } else if (this.summoningPedestal != null && this.summoningPedestal.getOwnerUUID() != null) {
                this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(this.summoningPedestal.getOwnerUUID()));
            } else {
                this.field_70180_af.func_187227_b(OWNER_UUID, Optional.empty());
            }
        } else {
            this.ownerUUID = ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).orElse(null);
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70089_S()) {
            if (this.summoningPedestal != null) {
                if (this.summonType == null) {
                    this.func_70106_y();
                    return;
                }
            } else {
                if (this.shootingEntity == null || !this.shootingEntity.func_70089_S() || this.portalItem == null) {
                    this.func_70106_y();
                    return;
                }
                playerExt = ExtendedPlayer.getForPlayer(this.shootingEntity);
                if (playerExt != null && playerExt.staffPortal != this) {
                    this.func_70106_y();
                    return;
                }
            }
        }
        this.moveToTarget();
        if (this.shootingEntity != null && this.summoningPedestal == null) {
            playerExt = ExtendedPlayer.getForPlayer(this.shootingEntity);
            if (playerExt != null && this.portalItem != null && ++this.summonTick >= this.portalItem.getRapidTime(null)) {
                this.summonDuration = this.portalItem.getSummonDuration();
                if (this.shootingEntity.field_71075_bZ.field_75098_d) {
                    this.summonAmount += this.portalItem.getSummonAmount();
                } else {
                    float summonMultiplier;
                    int summonCost;
                    int creatureSummonCost = 4;
                    if (this.creatureInfo != null) {
                        creatureSummonCost = this.creatureInfo.summonCost;
                    }
                    if (playerExt.summonFocus >= (summonCost = Math.round((float)playerExt.summonFocusCharge * (summonMultiplier = (float)(creatureSummonCost + this.portalItem.getSummonCostBoost()) * this.portalItem.getSummonCostMod()))) && this.portalItem.getAdditionalCosts(this.shootingEntity)) {
                        playerExt.summonFocus -= summonCost;
                        this.summonAmount += this.portalItem.getSummonAmount();
                    }
                }
                this.summonTick = 0;
            }
        } else if (this.summonType != null && ++this.summonTick >= this.summonTime) {
            this.summonAmount = this.summoningPedestal.summonAmount;
            this.summonTick = 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                double angle = Math.toRadians(this.field_70146_Z.nextFloat() * 360.0f);
                float distance = this.field_70146_Z.nextFloat() * 2.0f;
                double x = (double)distance * Math.cos(angle) + Math.sin(angle);
                double z = (double)distance * Math.sin(angle) - Math.cos(angle);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t + x, this.field_70163_u + (double)(4.0f * this.field_70146_Z.nextFloat()) - 2.0, this.field_70161_v + z, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    public int summonCreatures() {
        if (this.func_130014_f_().field_72995_K) {
            return 1;
        }
        if (this.summonType == null) {
            return 0;
        }
        for (int i = 0; i < this.summonAmount; ++i) {
            Entity entity = this.summonType.func_200721_a(this.func_130014_f_());
            if (entity == null) {
                return 0;
            }
            entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof BaseCreatureEntity) {
                BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
                if (this.shootingEntity != null && this.summoningPedestal == null) {
                    entityCreature.setMinion(true);
                    if (entityCreature instanceof TameableCreatureEntity) {
                        ((TameableCreatureEntity)entityCreature).setPlayerOwner(this.shootingEntity);
                        if (this.portalItem != null) {
                            this.portalItem.applyMinionBehaviour((TameableCreatureEntity)entityCreature, this.shootingEntity);
                            this.portalItem.applyMinionEffects(entityCreature);
                        }
                    }
                } else if (this.summoningPedestal != null && this.summoningPedestal.getOwnerUUID() != null) {
                    entityCreature.setMinion(true);
                    if (entityCreature instanceof TameableCreatureEntity) {
                        ((TameableCreatureEntity)entityCreature).setOwnerId(this.summoningPedestal.getOwnerUUID());
                        this.summoningPedestal.applyMinionBehaviour((TameableCreatureEntity)entityCreature);
                    }
                }
                if (this.summonDuration > 0) {
                    entityCreature.setTemporary(this.summonDuration);
                }
                if (this.shootingEntity != null) {
                    // empty if block
                }
            }
            this.func_130014_f_().func_217376_c(entity);
        }
        int amount = this.summonAmount;
        this.summonAmount = 0;
        return amount;
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    public void moveToTarget() {
        if (this.shootingEntity != null && this.summoningPedestal == null) {
            Vec3d lookDirection = this.shootingEntity.func_70040_Z();
            this.targetX = this.shootingEntity.field_70165_t + lookDirection.field_72450_a * this.portalRange;
            this.targetY = this.shootingEntity.field_70163_u + lookDirection.field_72448_b * this.portalRange;
            this.targetZ = this.shootingEntity.field_70161_v + lookDirection.field_72449_c * this.portalRange;
            RayTraceResult target = Utilities.raytrace(this.func_130014_f_(), this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u, this.shootingEntity.field_70161_v, this.targetX, this.targetY, this.targetZ, 1.0f, (Entity)this, null);
            if (target != null) {
                this.targetX = target.func_216347_e().field_72450_a;
                this.targetY = target.func_216347_e().field_72448_b;
                this.targetZ = target.func_216347_e().field_72449_c;
            }
            this.targetY += 1.0;
            this.field_70165_t = this.targetX;
            this.field_70163_u = this.targetY;
            this.field_70161_v = this.targetZ;
        }
    }

    public double[] getFacingPosition(Entity entity, double distance) {
        double angle = Math.toRadians(this.field_70177_z);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    @Override
    protected void func_70184_a(RayTraceResult movingObjectPos) {
    }

    @Override
    public ResourceLocation getTexture() {
        if (TextureManager.getTexture(this.entityName) == null) {
            TextureManager.addTexture(this.entityName, LycanitesMobs.modInfo, "textures/particles/" + this.entityName.toLowerCase() + ".png");
        }
        if (TextureManager.getTexture(this.entityName + "_client") == null) {
            TextureManager.addTexture(this.entityName + "_client", LycanitesMobs.modInfo, "textures/particles/" + this.entityName.toLowerCase() + "_client.png");
        }
        if (TextureManager.getTexture(this.entityName + "_player") == null) {
            TextureManager.addTexture(this.entityName + "_player", LycanitesMobs.modInfo, "textures/particles/" + this.entityName.toLowerCase() + "_player.png");
        }
        if (this.ownerUUID != null) {
            if (this.ownerUUID.equals(ClientManager.getInstance().getClientPlayer().func_110124_au())) {
                return TextureManager.getTexture(this.entityName + "_client");
            }
            return TextureManager.getTexture(this.entityName + "_player");
        }
        return TextureManager.getTexture(this.entityName);
    }

    @Override
    public float getTextureOffsetY() {
        return this.func_213305_a((Pose)Pose.STANDING).field_220316_b / 2.0f;
    }
}

