/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.VersionChecker;
import com.lycanitesmobs.core.capabilities.IExtendedPlayer;
import com.lycanitesmobs.core.config.ConfigExtra;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.PortalEntity;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.summoningstaff.ItemStaffSummoning;
import com.lycanitesmobs.core.network.MessagePetEntry;
import com.lycanitesmobs.core.network.MessagePetEntryRemove;
import com.lycanitesmobs.core.network.MessagePlayerStats;
import com.lycanitesmobs.core.network.MessageSummonSet;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.DonationFamiliars;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtendedPlayer
implements IExtendedPlayer {
    public static Map<PlayerEntity, ExtendedPlayer> clientExtendedPlayers = new HashMap<PlayerEntity, ExtendedPlayer>();
    public static Map<String, CompoundNBT> backupNBTTags = new HashMap<String, CompoundNBT>();
    public PlayerEntity player;
    public Beastiary beastiary;
    public PetManager petManager;
    public long timePlayed = 0L;
    public CreatureType selectedCreatureType;
    public CreatureInfo selectedCreature;
    public int selectedSubspecies = 0;
    public int selectedPetType = 0;
    public PetEntry selectedPet;
    public long currentTick = 0L;
    public boolean needsFirstSync = true;
    public BlockState justBrokenBlock;
    protected int justBrokenClearTime;
    public byte controlStates = 0;
    public boolean hasAttacked = false;
    public int spiritCharge = 100;
    public int spiritMax;
    public int spirit = this.spiritMax = this.spiritCharge * 10;
    public int spiritReserved = 0;
    public int selectedSummonSet = 1;
    public int summonFocusCharge = 600;
    public int summonFocusMax;
    public int summonFocus = this.summonFocusMax = this.summonFocusCharge * 10;
    public Map<Integer, SummonSet> summonSets = new HashMap<Integer, SummonSet>();
    public int summonSetMax = 5;
    public PortalEntity staffPortal;
    private boolean initialSetup = false;

    public static ExtendedPlayer getForPlayer(PlayerEntity player) {
        if (player == null) {
            return null;
        }
        if (player.func_130014_f_().field_72995_K) {
            if (clientExtendedPlayers.containsKey(player)) {
                ExtendedPlayer extendedPlayer = clientExtendedPlayers.get(player);
                extendedPlayer.setPlayer(player);
                return extendedPlayer;
            }
            ExtendedPlayer extendedPlayer = new ExtendedPlayer();
            extendedPlayer.setPlayer(player);
            clientExtendedPlayers.put(player, extendedPlayer);
            return extendedPlayer;
        }
        IExtendedPlayer iExtendedPlayer = (IExtendedPlayer)player.getCapability(LycanitesMobs.EXTENDED_PLAYER, null).orElse(null);
        if (!(iExtendedPlayer instanceof ExtendedPlayer)) {
            return null;
        }
        ExtendedPlayer extendedPlayer = (ExtendedPlayer)iExtendedPlayer;
        if (extendedPlayer.getPlayer() != player) {
            extendedPlayer.setPlayer(player);
        }
        return extendedPlayer;
    }

    public ExtendedPlayer() {
        this.beastiary = new Beastiary(this);
        this.petManager = new PetManager((LivingEntity)this.player);
    }

    public void backupPlayer() {
        if (this.player != null) {
            CompoundNBT nbtTagCompound = new CompoundNBT();
            this.writeNBT(nbtTagCompound);
            backupNBTTags.put(this.player.func_110124_au().toString(), nbtTagCompound);
        }
    }

    public void setPlayer(PlayerEntity player) {
        this.player = player;
        this.petManager.host = player;
        this.player.func_130014_f_();
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        if (backupNBTTags.containsKey(this.player.func_110124_au().toString())) {
            this.readNBT(backupNBTTags.get(this.player.func_110124_au().toString()));
            backupNBTTags.remove(this.player.func_110124_au().toString());
        }
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public boolean canMeleeBigEntity(Entity targetEntity) {
        double range;
        double distance;
        if (!(targetEntity instanceof LivingEntity)) {
            return false;
        }
        float targetWidth = targetEntity.func_213311_cf();
        float targetHeight = targetEntity.func_213302_cg();
        if (targetEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity targetCreature = (BaseCreatureEntity)targetEntity;
            targetWidth *= targetCreature.hitAreaWidthScale;
            targetHeight *= targetCreature.hitAreaHeightScale;
        }
        if (targetWidth <= 4.0f && targetHeight <= 4.0f) {
            return false;
        }
        double heightOffset = this.player.field_70163_u - targetEntity.field_70163_u;
        double heightCompensation = 0.0;
        if (heightOffset > 0.0) {
            heightCompensation = Math.min(heightOffset, (double)targetHeight);
        }
        return (distance = Math.sqrt(this.player.func_70032_d(targetEntity))) <= (range = 6.0 + heightCompensation + (double)(targetWidth / 2.0f));
    }

    public void meleeAttack(Entity targetEntity) {
        if (!this.hasAttacked && this.player.func_184614_ca() != null && this.canMeleeBigEntity(targetEntity)) {
            this.player.func_71059_n(targetEntity);
            this.player.func_184821_cY();
            this.player.func_184609_a(Hand.MAIN_HAND);
        }
    }

    public void onUpdate() {
        Object message;
        ++this.timePlayed;
        this.hasAttacked = false;
        boolean creative = this.player.field_71075_bZ.field_75098_d;
        boolean sync = false;
        if (this.justBrokenClearTime > 0 && --this.justBrokenClearTime <= 0) {
            this.justBrokenBlock = null;
        }
        this.spirit = Math.min(Math.max(this.spirit, 0), this.spiritMax - this.spiritReserved);
        if (this.spirit < this.spiritMax - this.spiritReserved) {
            ++this.spirit;
            if (!this.player.func_130014_f_().field_72995_K && this.currentTick % 20L == 0L || this.spirit == this.spiritMax - this.spiritReserved) {
                sync = true;
            }
        }
        this.summonFocus = Math.min(Math.max(this.summonFocus, 0), this.summonFocusMax);
        if (this.summonFocus < this.summonFocusMax) {
            ++this.summonFocus;
            if (!this.player.func_130014_f_().field_72995_K && !creative && this.currentTick % 20L == 0L || this.summonFocus < this.summonFocusMax || this.player.func_184614_ca().func_77973_b() instanceof ItemStaffSummoning || this.player.func_184592_cb().func_77973_b() instanceof ItemStaffSummoning) {
                sync = true;
            }
        }
        if (!this.player.func_130014_f_().field_72995_K && sync) {
            message = new MessagePlayerStats(this);
            LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.player);
        }
        if (!this.initialSetup) {
            Map<String, PetEntry> playerFamiliars;
            if (!this.player.func_130014_f_().field_72995_K && (playerFamiliars = DonationFamiliars.instance.getFamiliarsForPlayer(this.player)) != null) {
                this.petManager.clearEntries("familiar");
                for (PetEntry petEntry : playerFamiliars.values()) {
                    if (this.petManager.hasEntry(petEntry)) continue;
                    this.petManager.addEntry(petEntry);
                    petEntry.entity = null;
                }
                this.sendPetEntriesToPlayer("familiar");
            }
            if (this.player.func_130014_f_().field_72995_K) {
                VersionChecker.VersionInfo latestVersion = VersionChecker.getLatestVersion(true);
                VersionChecker.enabled = (Boolean)ConfigExtra.INSTANCE.versionCheckerEnabled.get();
                if (latestVersion != null && latestVersion.isNewer && VersionChecker.enabled) {
                    String versionText = new TranslationTextComponent("lyc.version.newer", new Object[0]).getString().replace("{current}", "2.1.0.0").replace("{latest}", latestVersion.versionNumber);
                    this.player.func_145747_a((ITextComponent)new StringTextComponent(versionText));
                }
            }
            this.initialSetup = true;
        }
        if (!this.player.func_130014_f_().field_72995_K && this.needsFirstSync) {
            this.beastiary.sendAllToClient();
            this.sendAllSummonSetsToPlayer();
            message = new MessageSummonSetSelection(this);
            LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.player);
        }
        this.petManager.onUpdate(this.player.func_130014_f_());
        ++this.currentTick;
        this.needsFirstSync = false;
    }

    public void setJustBrokenBlock(BlockState blockState) {
        this.justBrokenBlock = blockState;
        this.justBrokenClearTime = 60;
    }

    public SummonSet getSummonSet(int setID) {
        if (setID <= 0) {
            LycanitesMobs.logWarning("", "Attempted to access set " + setID + " but the minimum ID is 1. Player: " + this.player);
            return this.getSummonSet(1);
        }
        if (setID > this.summonSetMax) {
            LycanitesMobs.logWarning("", "Attempted to access set " + setID + " but the maximum set ID is " + this.summonSetMax + ". Player: " + this.player);
            return this.getSummonSet(this.summonSetMax);
        }
        if (!this.summonSets.containsKey(setID)) {
            this.summonSets.put(setID, new SummonSet(this));
        }
        return this.summonSets.get(setID);
    }

    public SummonSet getSelectedSummonSet() {
        return this.getSummonSet(this.selectedSummonSet);
    }

    public void setSelectedSummonSet(int targetSetID) {
        this.selectedSummonSet = targetSetID;
    }

    public int validateSummonSetID(int targetSetID) {
        for (targetSetID = Math.max(Math.min(targetSetID, this.summonSetMax), 1); !this.getSummonSet(targetSetID).isUseable() && targetSetID > 1 && !"".equals(this.getSummonSet((int)targetSetID).summonType); --targetSetID) {
        }
        return targetSetID;
    }

    public Beastiary getBeastiary() {
        return this.beastiary;
    }

    public void onDeath() {
    }

    public void sendPetEntriesToPlayer(String entryType) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        for (PetEntry petEntry : this.petManager.allEntries.values()) {
            if (!entryType.equals(petEntry.getType()) && !"".equals(entryType)) continue;
            MessagePetEntry message = new MessagePetEntry(this, petEntry);
            LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.player);
        }
    }

    public void sendPetEntryToPlayer(PetEntry petEntry) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.player);
    }

    public void sendPetEntryToServer(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendPetEntryRemoveRequest(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        petEntry.remove();
        MessagePetEntryRemove message = new MessagePetEntryRemove(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendAllSummonSetsToPlayer() {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        for (byte setID = 1; setID <= this.summonSetMax; setID = (byte)(setID + 1)) {
            MessageSummonSet message = new MessageSummonSet(this, setID);
            LycanitesMobs.packetHandler.sendToPlayer(message, (ServerPlayerEntity)this.player);
        }
    }

    public void sendSummonSetToServer(byte setID) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessageSummonSet message = new MessageSummonSet(this, setID);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void updateControlStates(byte controlStates) {
        this.controlStates = controlStates;
    }

    public boolean isControlActive(CONTROL_ID controlID) {
        return (this.controlStates & controlID.id) > 0;
    }

    public void onOpenBeastiary() {
        this.sendPetEntriesToPlayer("pet");
        this.sendPetEntriesToPlayer("mount");
        this.sendPetEntriesToPlayer("familiar");
    }

    public void readNBT(CompoundNBT nbtTagCompound) {
        CompoundNBT extTagCompound = nbtTagCompound.func_74775_l("LycanitesMobsPlayer");
        this.beastiary.readFromNBT(extTagCompound);
        this.petManager.readFromNBT(extTagCompound);
        if (extTagCompound.func_74764_b("SummonFocus")) {
            this.summonFocus = extTagCompound.func_74762_e("SummonFocus");
        }
        if (extTagCompound.func_74764_b("Spirit")) {
            this.spirit = extTagCompound.func_74762_e("Spirit");
        }
        if (extTagCompound.func_74764_b("SelectedSummonSet")) {
            this.selectedSummonSet = extTagCompound.func_74762_e("SelectedSummonSet");
        }
        if (extTagCompound.func_74764_b("SummonSets")) {
            ListNBT nbtSummonSets = extTagCompound.func_150295_c("SummonSets", 10);
            for (int setID = 0; setID < this.summonSetMax; ++setID) {
                CompoundNBT nbtSummonSet = (CompoundNBT)nbtSummonSets.get(setID);
                SummonSet summonSet = new SummonSet(this);
                summonSet.read(nbtSummonSet);
                this.summonSets.put(setID + 1, summonSet);
            }
        }
        if (extTagCompound.func_74764_b("TimePlayed")) {
            this.timePlayed = extTagCompound.func_74763_f("TimePlayed");
        }
    }

    public void writeNBT(CompoundNBT nbtTagCompound) {
        CompoundNBT extTagCompound = new CompoundNBT();
        this.beastiary.writeToNBT(extTagCompound);
        this.petManager.writeToNBT(extTagCompound);
        extTagCompound.func_74768_a("SummonFocus", this.summonFocus);
        extTagCompound.func_74768_a("Spirit", this.spirit);
        extTagCompound.func_74768_a("SelectedSummonSet", this.selectedSummonSet);
        extTagCompound.func_74772_a("TimePlayed", this.timePlayed);
        ListNBT nbtSummonSets = new ListNBT();
        for (int setID = 0; setID < this.summonSetMax; ++setID) {
            CompoundNBT nbtSummonSet = new CompoundNBT();
            SummonSet summonSet = this.getSummonSet(setID + 1);
            summonSet.write(nbtSummonSet);
            nbtSummonSets.add((Object)nbtSummonSet);
        }
        extTagCompound.func_218657_a("SummonSets", (INBT)nbtSummonSets);
        nbtTagCompound.func_218657_a("LycanitesMobsPlayer", (INBT)extTagCompound);
    }

    public static enum CONTROL_ID {
        JUMP(1),
        MOUNT_ABILITY(2),
        MOUNT_INVENTORY(4),
        ATTACK(8);

        public byte id;

        private CONTROL_ID(byte i) {
            this.id = i;
        }
    }
}

