/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.instance;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.block.BlockFireBase;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.dungeon.definition.SectorLayer;
import com.lycanitesmobs.core.dungeon.instance.DungeonLayout;
import com.lycanitesmobs.core.dungeon.instance.SectorConnector;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.spawner.MobSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SectorInstance {
    public DungeonLayout layout;
    public DungeonSector dungeonSector;
    public SectorConnector parentConnector;
    public List<SectorConnector> connectors = new ArrayList<SectorConnector>();
    protected Vec3i roomSize;
    protected Vec3i occupiedSize;
    public DungeonTheme theme;
    public BlockState lightBlock;
    public BlockState torchBlock;
    public BlockState stairBlock;
    public BlockState pitBlock;
    public int chunksBuilt = 0;

    public SectorInstance(DungeonLayout layout, DungeonSector dungeonSector, Random random) {
        this.layout = layout;
        this.dungeonSector = dungeonSector;
        this.roomSize = this.dungeonSector.getRandomSize(random);
        this.occupiedSize = new Vec3i(this.roomSize.func_177958_n() + Math.max(1, this.dungeonSector.padding.func_177958_n()), this.roomSize.func_177956_o() + this.dungeonSector.padding.func_177956_o(), this.roomSize.func_177952_p() + Math.max(1, this.dungeonSector.padding.func_177952_p()));
    }

    public void connect(SectorConnector parentConnector) {
        this.parentConnector = parentConnector;
    }

    public void init(Random random) {
        int y;
        if (this.parentConnector == null) {
            LycanitesMobs.logWarning("Dungeon", "Tried to initialise a Sector Instance with a null Parent Connector: " + this);
            return;
        }
        this.parentConnector.childSector = this;
        this.parentConnector.closed = true;
        if (this.layout.openConnectors.contains(this.parentConnector)) {
            this.layout.openConnectors.remove(this.parentConnector);
        }
        this.theme = this.dungeonSector.changeTheme || this.parentConnector.parentSector == null ? this.layout.dungeonInstance.schematic.getRandomTheme(random) : this.parentConnector.parentSector.theme;
        this.lightBlock = this.theme.getLight('B', random);
        this.torchBlock = this.theme.getTorch('B', random);
        this.stairBlock = this.theme.getStairs('B', random);
        this.pitBlock = this.theme.getPit('B', random);
        BlockPos boundsMin = this.getRoomBoundsMin();
        BlockPos boundsMax = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = boundsMin.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = boundsMin.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        if ("corridor".equalsIgnoreCase(this.dungeonSector.type) || "room".equalsIgnoreCase(this.dungeonSector.type) || "entrance".equalsIgnoreCase(this.dungeonSector.type) || "bossRoom".equalsIgnoreCase(this.dungeonSector.type)) {
            BlockPos blockPos = this.parentConnector.position;
            if (this.parentConnector.facing == Direction.SOUTH) {
                blockPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMax.func_177952_p() + 1);
            } else if (this.parentConnector.facing == Direction.EAST) {
                blockPos = new BlockPos(boundsMax.func_177958_n() + 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
            } else if (this.parentConnector.facing == Direction.NORTH) {
                blockPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMin.func_177952_p() - 1);
            } else if (this.parentConnector.facing == Direction.WEST) {
                blockPos = new BlockPos(boundsMin.func_177958_n() - 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
            }
            this.addConnector(blockPos, this.parentConnector.level, this.parentConnector.facing);
            if ("room".equalsIgnoreCase(this.dungeonSector.type)) {
                BlockPos leftPos = this.parentConnector.position;
                Direction leftFacing = Direction.WEST;
                BlockPos rightPos = this.parentConnector.position;
                Direction rightFacing = Direction.EAST;
                if (this.parentConnector.facing == Direction.SOUTH || this.parentConnector.facing == Direction.NORTH) {
                    leftPos = new BlockPos(boundsMin.func_177958_n() - 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                    leftFacing = Direction.WEST;
                    rightPos = new BlockPos(boundsMax.func_177958_n() + 1, this.parentConnector.position.func_177956_o(), this.getConnectorOffset(random, size.func_177952_p(), boundsMin.func_177952_p()));
                    rightFacing = Direction.EAST;
                } else if (this.parentConnector.facing == Direction.EAST || this.parentConnector.facing == Direction.WEST) {
                    leftPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMax.func_177952_p() + 1);
                    leftFacing = Direction.SOUTH;
                    rightPos = new BlockPos(this.getConnectorOffset(random, size.func_177958_n(), boundsMin.func_177958_n()), this.parentConnector.position.func_177956_o(), boundsMin.func_177952_p() - 1);
                    rightFacing = Direction.NORTH;
                }
                this.addConnector(leftPos, this.parentConnector.level, leftFacing);
                this.addConnector(rightPos, this.parentConnector.level, rightFacing);
            }
        } else if ("stairs".equalsIgnoreCase(this.dungeonSector.type) && (y = this.parentConnector.position.func_177956_o() - size.func_177956_o() * 2) > 0) {
            BlockPos blockPos = new BlockPos(centerX, y, boundsMax.func_177952_p() + 1);
            if (this.parentConnector.facing == Direction.EAST) {
                blockPos = new BlockPos(boundsMax.func_177958_n() + 1, y, centerZ);
            } else if (this.parentConnector.facing == Direction.NORTH) {
                blockPos = new BlockPos(centerX, y, boundsMin.func_177952_p() - 1);
            } else if (this.parentConnector.facing == Direction.WEST) {
                blockPos = new BlockPos(boundsMin.func_177958_n() - 1, y, centerZ);
            }
            this.addConnector(blockPos, this.parentConnector.level + 1, this.parentConnector.facing);
        }
    }

    public int getConnectorOffset(Random random, int length, int start) {
        int entrancePadding = 2;
        if (!"room".equalsIgnoreCase(this.dungeonSector.type) || length <= entrancePadding * 2) {
            return start + Math.round((float)length / 2.0f);
        }
        return start + entrancePadding + random.nextInt(length - entrancePadding * 2) + 1;
    }

    public SectorConnector addConnector(BlockPos blockPos, int level, Direction facing) {
        SectorConnector connector = new SectorConnector(blockPos, this, level, facing);
        this.connectors.add(connector);
        return connector;
    }

    public SectorConnector getRandomConnector(Random random, SectorInstance sectorInstance) {
        List<SectorConnector> openConnectors = this.getOpenConnectors(sectorInstance);
        if (openConnectors.isEmpty()) {
            return null;
        }
        if (openConnectors.size() == 1) {
            return openConnectors.get(0);
        }
        return openConnectors.get(random.nextInt(openConnectors.size()));
    }

    public List<SectorConnector> getOpenConnectors(SectorInstance sectorInstance) {
        ArrayList<SectorConnector> openConnectors = new ArrayList<SectorConnector>();
        for (SectorConnector connector : this.connectors) {
            if (!connector.canConnect(this.layout, sectorInstance)) continue;
            openConnectors.add(connector);
        }
        return openConnectors;
    }

    public List<ChunkPos> getChunkPositions() {
        ChunkPos minChunkPos = new ChunkPos(this.getOccupiedBoundsMin().func_177982_a(-1, 0, -1));
        ChunkPos maxChunkPos = new ChunkPos(this.getOccupiedBoundsMax().func_177982_a(1, 0, 1));
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        for (int x = minChunkPos.field_77276_a; x <= maxChunkPos.field_77276_a; ++x) {
            for (int z = minChunkPos.field_77275_b; z <= maxChunkPos.field_77275_b; ++z) {
                chunkPosList.add(new ChunkPos(x, z));
            }
        }
        return chunkPosList;
    }

    public List<SectorInstance> getNearbySectors() {
        ArrayList<SectorInstance> nearbySectors = new ArrayList<SectorInstance>();
        for (SectorInstance nearbySector : this.layout.sectors) {
            if (nearbySectors.contains(nearbySector)) continue;
            nearbySectors.add(nearbySector);
        }
        return nearbySectors;
    }

    public boolean collidesWith(SectorInstance sectorInstance) {
        boolean withinZ;
        boolean withinY;
        boolean withinX;
        if (sectorInstance == this) {
            return false;
        }
        BlockPos boundsMin = this.getOccupiedBoundsMin();
        BlockPos boundsMax = this.getOccupiedBoundsMax();
        BlockPos targetMin = sectorInstance.getOccupiedBoundsMin();
        BlockPos targetMax = sectorInstance.getOccupiedBoundsMax();
        boolean bl = withinX = boundsMin.func_177958_n() > targetMin.func_177958_n() && boundsMin.func_177958_n() < targetMax.func_177958_n();
        if (!withinX) {
            boolean bl2 = withinX = boundsMax.func_177958_n() > targetMin.func_177958_n() && boundsMax.func_177958_n() < targetMax.func_177958_n();
        }
        if (!withinX) {
            return false;
        }
        boolean bl3 = withinY = boundsMin.func_177956_o() > targetMin.func_177956_o() && boundsMin.func_177956_o() < targetMax.func_177956_o();
        if (!withinY) {
            boolean bl4 = withinY = boundsMax.func_177956_o() > targetMin.func_177956_o() && boundsMax.func_177956_o() < targetMax.func_177956_o();
        }
        if (!withinY) {
            return false;
        }
        boolean bl5 = withinZ = boundsMin.func_177952_p() > targetMin.func_177952_p() && boundsMin.func_177952_p() < targetMax.func_177952_p();
        if (!withinZ) {
            boolean bl6 = withinZ = boundsMax.func_177952_p() > targetMin.func_177952_p() && boundsMax.func_177952_p() < targetMax.func_177952_p();
        }
        return withinZ;
    }

    public Vec3i getRoomSize() {
        if (this.parentConnector.facing == Direction.EAST || this.parentConnector.facing == Direction.WEST) {
            return new Vec3i(this.roomSize.func_177952_p(), this.roomSize.func_177956_o(), this.roomSize.func_177958_n());
        }
        return this.roomSize;
    }

    public Vec3i getOccupiedSize() {
        if (this.parentConnector.facing == Direction.EAST || this.parentConnector.facing == Direction.WEST) {
            return new Vec3i(this.occupiedSize.func_177952_p(), this.occupiedSize.func_177956_o(), this.occupiedSize.func_177958_n());
        }
        return this.occupiedSize;
    }

    public BlockPos getBoundsMin(Vec3i boundsSize) {
        BlockPos bounds = new BlockPos((Vec3i)this.parentConnector.position);
        if (this.parentConnector.facing == Direction.SOUTH) {
            bounds = bounds.func_177982_a(-((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0)), 0, 0);
        } else if (this.parentConnector.facing == Direction.EAST) {
            bounds = bounds.func_177982_a(0, 0, -((int)Math.ceil((double)boundsSize.func_177952_p() / 2.0)));
        } else if (this.parentConnector.facing == Direction.NORTH) {
            bounds = bounds.func_177982_a(-((int)Math.ceil((double)boundsSize.func_177958_n() / 2.0)), 0, -boundsSize.func_177952_p());
        } else if (this.parentConnector.facing == Direction.WEST) {
            bounds = bounds.func_177982_a(-boundsSize.func_177958_n(), 0, -((int)Math.ceil((double)boundsSize.func_177952_p() / 2.0)));
        }
        return bounds;
    }

    public BlockPos getBoundsMax(Vec3i boundsSize) {
        BlockPos bounds = new BlockPos((Vec3i)this.parentConnector.position);
        if (this.parentConnector.facing == Direction.SOUTH) {
            bounds = bounds.func_177982_a((int)Math.floor((double)boundsSize.func_177958_n() / 2.0), boundsSize.func_177956_o(), boundsSize.func_177952_p());
        } else if (this.parentConnector.facing == Direction.EAST) {
            bounds = bounds.func_177982_a(boundsSize.func_177958_n(), boundsSize.func_177956_o(), (int)Math.floor((double)boundsSize.func_177952_p() / 2.0));
        } else if (this.parentConnector.facing == Direction.NORTH) {
            bounds = bounds.func_177982_a((int)Math.floor((double)boundsSize.func_177958_n() / 2.0), boundsSize.func_177956_o(), 0);
        } else if (this.parentConnector.facing == Direction.WEST) {
            bounds = bounds.func_177982_a(0, boundsSize.func_177956_o(), (int)Math.floor((double)boundsSize.func_177952_p() / 2.0));
        }
        return bounds;
    }

    public BlockPos getOccupiedBoundsMin() {
        Vec3i occupiedSize = this.getOccupiedSize();
        if ("stairs".equals(this.dungeonSector.type)) {
            occupiedSize = new Vec3i(occupiedSize.func_177958_n(), occupiedSize.func_177956_o() - this.getRoomSize().func_177956_o() * 2, occupiedSize.func_177952_p());
        }
        return this.getBoundsMin(occupiedSize).func_177982_a(-8, 0, -8);
    }

    public BlockPos getOccupiedBoundsMax() {
        return this.getBoundsMax(this.getOccupiedSize()).func_177982_a(-8, 0, -8);
    }

    public BlockPos getRoomBoundsMin() {
        return this.getBoundsMin(this.getRoomSize());
    }

    public BlockPos getRoomBoundsMax() {
        return this.getBoundsMax(this.getRoomSize());
    }

    public BlockPos getCenter() {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = startPos.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = startPos.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        return new BlockPos(centerX, startPos.func_177956_o(), centerZ);
    }

    public void placeBlock(IWorld worldWriter, ChunkPos chunkPos, BlockPos blockPos, BlockState blockState, Direction facing, Random random) {
        TileEntity tileEntity;
        int chunkOffset = 0;
        if (blockPos.func_177958_n() < chunkPos.func_180334_c() + chunkOffset || blockPos.func_177958_n() > chunkPos.func_180332_e() + chunkOffset) {
            return;
        }
        if (blockPos.func_177956_o() <= 0 || blockPos.func_177956_o() >= worldWriter.func_217301_I()) {
            return;
        }
        if (blockPos.func_177952_p() < chunkPos.func_180333_d() + chunkOffset || blockPos.func_177952_p() > chunkPos.func_180330_f() + chunkOffset) {
            return;
        }
        int flags = 2;
        if (blockState.func_177230_c() == Blocks.field_150478_aa) {
            blockState = (BlockState)blockState.func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)facing);
            flags = 0;
        }
        if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_177230_c() == Blocks.field_201941_jj || blockState.func_177230_c() instanceof FlowingFluidBlock || blockState.func_177230_c() instanceof FireBlock || blockState.func_177230_c() instanceof BlockFireBase) {
            flags = 0;
        }
        worldWriter.func_180501_a(blockPos, blockState, flags);
        if (blockState.func_177230_c() == Blocks.field_150474_ac) {
            TileEntity tileEntity2 = worldWriter.func_175625_s(blockPos);
            if (tileEntity2 instanceof MobSpawnerTileEntity) {
                MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)tileEntity2;
                MobSpawn mobSpawn = this.layout.dungeonInstance.schematic.getRandomMobSpawn(this.parentConnector.level, false, random);
                if (mobSpawn != null && mobSpawn.entityType != null) {
                    spawner.func_145881_a().func_200876_a(mobSpawn.entityType);
                }
            }
            return;
        }
        if (blockState.func_177230_c() == Blocks.field_150486_ae && (tileEntity = worldWriter.func_175625_s(blockPos)) instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)tileEntity;
            ResourceLocation lootTable = this.layout.dungeonInstance.schematic.getRandomLootTable(this.parentConnector.level, random);
            if (lootTable != null) {
                chest.func_189404_a(lootTable, random.nextLong());
            }
        }
    }

    public void build(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        MobSpawn mobSpawn;
        this.clearArea(worldWriter, world, chunkPos, random);
        this.buildFloor(worldWriter, world, chunkPos, random, 0);
        this.buildWalls(worldWriter, world, chunkPos, random);
        this.buildCeiling(worldWriter, world, chunkPos, random);
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            this.buildStairs(worldWriter, world, chunkPos, random);
            this.buildFloor(worldWriter, world, chunkPos, random, -(this.getRoomSize().func_177956_o() * 2));
        }
        this.buildEntrances(worldWriter, world, chunkPos, random);
        ++this.chunksBuilt;
        if ("bossRoom".equalsIgnoreCase(this.dungeonSector.type) && (mobSpawn = this.layout.dungeonInstance.schematic.getRandomMobSpawn(this.parentConnector.level, true, random)) != null) {
            this.spawnMob(worldWriter, world, chunkPos, this.getCenter().func_177982_a(0, 1, 0), mobSpawn, random);
        }
    }

    public void clearArea(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            startY = Math.max(1, startPos.func_177956_o() - this.getRoomSize().func_177956_o() * 2);
        }
        for (int x = startX; x <= stopX; ++x) {
            for (int y = startY; y <= stopY; ++y) {
                for (int z = startZ; z <= stopZ; ++z) {
                    this.placeBlock(worldWriter, chunkPos, new BlockPos(x, y, z), Blocks.field_201941_jj.func_176223_P(), Direction.SOUTH, random);
                }
            }
        }
    }

    public void buildFloor(IWorld worldWriter, World world, ChunkPos chunkPos, Random random, int offsetY) {
        BlockPos startPos = this.getRoomBoundsMin().func_177982_a(0, offsetY, 0);
        BlockPos stopPos = this.getRoomBoundsMax().func_177982_a(0, offsetY, 0);
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        for (int layerIndex : this.dungeonSector.floor.layers.keySet()) {
            int y = startY + layerIndex;
            if (y <= 0 || y >= world.func_72940_L()) continue;
            SectorLayer layer = this.dungeonSector.floor.layers.get(layerIndex);
            for (int x = startX; x <= stopX; ++x) {
                List<Character> row = layer.getRow(x - startX, stopX - startX);
                for (int z = startZ; z <= stopZ; ++z) {
                    char buildChar = layer.getColumn(x - startX, stopX - startX, z - startZ, stopZ - startZ, row).charValue();
                    BlockPos buildPos = new BlockPos(x, y, z);
                    BlockState blockState = this.theme.getFloor(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_201941_jj) continue;
                    this.placeBlock(worldWriter, chunkPos, buildPos, blockState, Direction.UP, random);
                }
            }
        }
    }

    public void buildWalls(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o() + 1, stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o() - 1, stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        if ("stairs".equalsIgnoreCase(this.dungeonSector.type)) {
            startY = Math.max(1, startPos.func_177956_o() - size.func_177956_o() * 2);
        }
        for (int layerIndex : this.dungeonSector.wall.layers.keySet()) {
            SectorLayer layer = this.dungeonSector.wall.layers.get(layerIndex);
            for (int y = startY; y <= stopY; ++y) {
                BlockState blockState;
                char buildChar;
                if (y <= 0 || y >= world.func_72940_L()) continue;
                int progressY = y - startY;
                int fullY = stopY - startY;
                List<Character> row = layer.getRow(progressY, fullY);
                for (int x = startX; x <= stopX; ++x) {
                    buildChar = layer.getColumn(progressY, fullY, x - startX, stopX - startX, row).charValue();
                    blockState = this.theme.getWall(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_201941_jj) continue;
                    this.placeBlock(worldWriter, chunkPos, new BlockPos(x, y, startZ + layerIndex), blockState, Direction.SOUTH, random);
                    this.placeBlock(worldWriter, chunkPos, new BlockPos(x, y, stopZ - layerIndex), blockState, Direction.NORTH, random);
                }
                for (int z = startZ; z <= stopZ; ++z) {
                    buildChar = layer.getColumn(progressY, fullY, z - startZ, stopZ - startZ, row).charValue();
                    blockState = this.theme.getWall(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_201941_jj) continue;
                    this.placeBlock(worldWriter, chunkPos, new BlockPos(startX + layerIndex, y, z), blockState, Direction.EAST, random);
                    this.placeBlock(worldWriter, chunkPos, new BlockPos(stopX - layerIndex, y, z), blockState, Direction.WEST, random);
                }
            }
        }
    }

    public void buildCeiling(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        int startX = Math.min(startPos.func_177958_n(), stopPos.func_177958_n());
        int stopX = Math.max(startPos.func_177958_n(), stopPos.func_177958_n());
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(startPos.func_177956_o(), stopPos.func_177956_o());
        int startZ = Math.min(startPos.func_177952_p(), stopPos.func_177952_p());
        int stopZ = Math.max(startPos.func_177952_p(), stopPos.func_177952_p());
        for (int layerIndex : this.dungeonSector.ceiling.layers.keySet()) {
            int y = stopY + layerIndex;
            if (y <= 0 || y >= world.func_72940_L()) continue;
            SectorLayer layer = this.dungeonSector.ceiling.layers.get(layerIndex);
            for (int x = startX; x <= stopX; ++x) {
                List<Character> row = layer.getRow(x - startX, stopX - startX);
                for (int z = startZ; z <= stopZ; ++z) {
                    char buildChar = layer.getColumn(x - startX, stopX - startX, z - startZ, stopZ - startZ, row).charValue();
                    BlockPos buildPos = new BlockPos(x, y, z);
                    BlockState blockState = this.theme.getCeiling(this, buildChar, random);
                    if (blockState.func_177230_c() == Blocks.field_201941_jj) continue;
                    this.placeBlock(worldWriter, chunkPos, buildPos, blockState, Direction.DOWN, random);
                }
            }
        }
    }

    public void buildEntrances(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        this.parentConnector.buildEntrance(worldWriter, world, chunkPos, random);
    }

    public void buildStairs(IWorld worldWriter, World world, ChunkPos chunkPos, Random random) {
        BlockPos startPos = this.getRoomBoundsMin();
        BlockPos stopPos = this.getRoomBoundsMax();
        Vec3i size = this.getRoomSize();
        int centerX = startPos.func_177958_n() + Math.round((float)size.func_177958_n() / 2.0f);
        int centerZ = startPos.func_177952_p() + Math.round((float)size.func_177952_p() / 2.0f);
        int startX = centerX - 1;
        int stopX = centerX + 1;
        int startY = Math.min(startPos.func_177956_o(), stopPos.func_177956_o());
        int stopY = Math.max(1, startPos.func_177956_o() - size.func_177956_o() * 2);
        int startZ = centerZ - 1;
        int stopZ = centerZ + 1;
        BlockState floorBlockState = this.theme.getFloor(this, 'B', random);
        BlockState stairsBlockState = this.stairBlock;
        for (int y = startY; y >= stopY; --y) {
            for (int x = startX; x <= stopX; ++x) {
                for (int z = startZ; z <= stopZ; ++z) {
                    BlockState blockState = Blocks.field_201941_jj.func_176223_P();
                    if (x == centerX && z == centerZ) {
                        blockState = this.theme.getWall(this, 'B', random);
                    }
                    int step = startY - y % 8;
                    int offsetX = x - startX;
                    int offsetZ = z - startZ;
                    if (step % 4 == 0) {
                        if (offsetX == 0 && offsetZ == 0) {
                            blockState = floorBlockState;
                        } else if (offsetX == 0 && offsetZ == 1) {
                            blockState = stairsBlockState;
                        }
                    }
                    if (step % 4 == 1) {
                        if (offsetX == 0 && offsetZ == 2) {
                            blockState = floorBlockState;
                        } else if (offsetX == 1 && offsetZ == 2) {
                            blockState = (BlockState)stairsBlockState.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST);
                        }
                    }
                    if (step % 4 == 2) {
                        if (offsetX == 2 && offsetZ == 2) {
                            blockState = floorBlockState;
                        } else if (offsetX == 2 && offsetZ == 1) {
                            blockState = (BlockState)stairsBlockState.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH);
                        }
                    }
                    if (step % 4 == 3) {
                        if (offsetX == 2 && offsetZ == 0) {
                            blockState = floorBlockState;
                        } else if (offsetX == 1 && offsetZ == 0) {
                            blockState = (BlockState)stairsBlockState.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
                        }
                    }
                    BlockPos buildPos = new BlockPos(x, y, z);
                    this.placeBlock(worldWriter, chunkPos, buildPos, blockState, Direction.UP, random);
                }
            }
        }
    }

    public void spawnMob(IWorld worldWriter, World world, ChunkPos chunkPos, BlockPos blockPos, MobSpawn mobSpawn, Random random) {
        int chunkOffset = 8;
        if (blockPos.func_177958_n() < chunkPos.func_180334_c() + chunkOffset || blockPos.func_177958_n() > chunkPos.func_180332_e() + chunkOffset) {
            return;
        }
        if (blockPos.func_177956_o() <= 0 || blockPos.func_177956_o() >= world.func_72940_L()) {
            return;
        }
        if (blockPos.func_177952_p() < chunkPos.func_180333_d() + chunkOffset || blockPos.func_177952_p() > chunkPos.func_180330_f() + chunkOffset) {
            return;
        }
        LycanitesMobs.logDebug("Dungeon", "Spawning mob " + mobSpawn + " at: " + blockPos + " level: " + this.parentConnector.level);
        LivingEntity entityLiving = mobSpawn.createEntity(world);
        entityLiving.func_70107_b((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        if (entityLiving instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)entityLiving;
            entityCreature.setHome(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), Math.max(3, Math.max(this.roomSize.func_177958_n(), this.roomSize.func_177952_p())));
        }
        mobSpawn.onSpawned(entityLiving, null);
        worldWriter.func_217376_c((Entity)entityLiving);
    }

    public String toString() {
        String bounds = "";
        String size = "";
        if (this.parentConnector != null) {
            bounds = " Bounds: " + this.getOccupiedBoundsMin() + " to " + this.getOccupiedBoundsMax();
            size = " Occupies: " + this.getOccupiedSize();
        }
        return "Sector Instance Type: " + (this.dungeonSector == null ? "Unset" : this.dungeonSector.type) + " Parent Connector Pos: " + (this.parentConnector == null ? "Unset" : this.parentConnector.position) + size + bounds;
    }
}

