/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.dungeon.definition.DungeonSchematic;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.definition.DungeonStructure;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.info.ModInfo;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class DungeonManager
extends JSONLoader {
    public static DungeonManager INSTANCE;
    public Map<String, DungeonTheme> themes = new HashMap<String, DungeonTheme>();
    public Map<String, DungeonStructure> structures = new HashMap<String, DungeonStructure>();
    public Map<String, DungeonSector> sectors = new HashMap<String, DungeonSector>();
    public Map<String, DungeonSchematic> schematics = new HashMap<String, DungeonSchematic>();

    public static DungeonManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DungeonManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJson(ModInfo modInfo) {
        LycanitesMobs.logDebug("", "Loading Dungeon Themes...");
        this.loadAllJson(modInfo, "Dungeon Theme", "dungeons/themes", "name", true, null, FileLoader.SERVER, StreamLoader.SERVER);
        LycanitesMobs.logDebug("", "Complete! " + this.themes.size() + " Dungeon Themes Loaded In Total.");
        LycanitesMobs.logDebug("", "Loading Dungeon Structures...");
        this.loadAllJson(modInfo, "Dungeon Structure", "dungeons/structures", "name", true, null, FileLoader.SERVER, StreamLoader.SERVER);
        LycanitesMobs.logDebug("", "Complete! " + this.structures.size() + " Dungeon Structures Loaded In Total.");
        LycanitesMobs.logDebug("", "Loading Dungeon Sectors...");
        this.loadAllJson(modInfo, "Dungeon Sector", "dungeons/sectors", "name", true, null, FileLoader.SERVER, StreamLoader.SERVER);
        LycanitesMobs.logDebug("", "Complete! " + this.sectors.size() + " Dungeon Sectors Loaded In Total.");
        LycanitesMobs.logDebug("", "Loading Dungeon Schematics...");
        this.loadAllJson(modInfo, "Dungeon Schematic", "dungeons/schematics", "name", true, null, FileLoader.SERVER, StreamLoader.SERVER);
        LycanitesMobs.logDebug("", "Complete! " + this.schematics.size() + " Dungeon Schematics Loaded In Total.");
    }

    @Override
    public void parseJson(ModInfo modInfo, String loadGroup, JsonObject json) {
        if ("Dungeon Theme".equals(loadGroup)) {
            DungeonTheme theme = new DungeonTheme();
            theme.loadFromJSON(json);
            this.addTheme(theme);
            return;
        }
        if ("Dungeon Structure".equals(loadGroup)) {
            DungeonStructure structure = new DungeonStructure();
            structure.loadFromJSON(json);
            this.addStructure(structure);
            return;
        }
        if ("Dungeon Sector".equals(loadGroup)) {
            DungeonSector sector = new DungeonSector();
            sector.loadFromJSON(json);
            this.addSector(sector);
            return;
        }
        if ("Dungeon Schematic".equals(loadGroup)) {
            DungeonSchematic schematic = new DungeonSchematic();
            schematic.loadFromJSON(json);
            this.addSchematic(schematic);
            return;
        }
    }

    public Map<String, JsonObject> loadDungeonsFromJSON(String type, ModInfo modInfo) {
        LycanitesMobs.logDebug("Dungeon", "Loading JSON Dungeons " + type + "!");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> spawnerJSONs = new HashMap<String, JsonObject>();
        Path path = FileLoader.SERVER.getPath("dungeons/" + type);
        HashMap<String, JsonObject> defaultJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultJSONs, "name", null);
        String configPath = new File(".") + "/config/" + "lycanitesmobs" + "/";
        File customDir = new File(configPath + "dungeons/" + type);
        customDir.mkdirs();
        path = customDir.toPath();
        HashMap<String, JsonObject> customJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customJSONs, "name", null);
        this.writeDefaultJSONObjects(gson, defaultJSONs, customJSONs, spawnerJSONs, true, "dungeons/" + type);
        return spawnerJSONs;
    }

    public void reload() {
        LycanitesMobs.logDebug("Dungeon", "Destroying Dungeons for reload!");
        this.themes.clear();
        this.structures.clear();
        this.sectors.clear();
        this.schematics.clear();
        this.loadAllFromJson(LycanitesMobs.modInfo);
    }

    public void addTheme(DungeonTheme theme) {
        if (this.themes.containsKey(theme.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Theme with a name that is already in use: " + theme.name);
            return;
        }
        if (this.themes.values().contains(theme)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Theme that is already added: " + theme.name);
            return;
        }
        this.themes.put(theme.name, theme);
    }

    public void removeTheme(DungeonTheme theme) {
        if (!this.themes.containsKey(theme.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to remove a Dungeon Theme that hasn't been added: " + theme.name);
            return;
        }
        this.themes.remove(theme.name);
    }

    public DungeonTheme getTheme(String name) {
        if (!this.themes.containsKey(name)) {
            LycanitesMobs.logWarning("Dungeon", "Unable to find a theme called " + name);
            return null;
        }
        return this.themes.get(name);
    }

    public void addStructure(DungeonStructure structure) {
        if (this.structures.containsKey(structure.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Structure with a name that is already in use: " + structure.name);
            return;
        }
        if (this.structures.values().contains(structure)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Structure that is already added: " + structure.name);
            return;
        }
        this.structures.put(structure.name, structure);
    }

    public void removeStructure(DungeonStructure structure) {
        if (!this.structures.containsKey(structure.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to remove a Dungeon Structure that hasn't been added: " + structure.name);
            return;
        }
        this.structures.remove(structure.name);
    }

    public DungeonStructure getStructure(String name) {
        if (!this.structures.containsKey(name)) {
            return null;
        }
        return this.structures.get(name);
    }

    public void addSector(DungeonSector sector) {
        if (this.sectors.containsKey(sector.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Sector with a name that is already in use: " + sector.name);
            return;
        }
        if (this.sectors.values().contains(sector)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Sector that is already added: " + sector.name);
            return;
        }
        this.sectors.put(sector.name, sector);
    }

    public void removeSector(DungeonSector sector) {
        if (!this.sectors.containsKey(sector.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to remove a Dungeon Sector that hasn't been added: " + sector.name);
            return;
        }
        this.sectors.remove(sector.name);
    }

    public DungeonSector getSector(String name) {
        if (!this.sectors.containsKey(name)) {
            LycanitesMobs.logWarning("Dungeon", "Unable to find a Dungeon Sector by the name: " + name);
            return null;
        }
        return this.sectors.get(name);
    }

    public void addSchematic(DungeonSchematic schematic) {
        if (this.schematics.containsKey(schematic.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Schematic with a name that is already in use: " + schematic.name);
            return;
        }
        if (this.schematics.values().contains(schematic)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to add a Dungeon Schematic that is already added: " + schematic.name);
            return;
        }
        this.schematics.put(schematic.name, schematic);
    }

    public void removeSchematic(DungeonSchematic schematic) {
        if (!this.schematics.containsKey(schematic.name)) {
            LycanitesMobs.logWarning("", "[Dungeon Manager] Tried to remove a Dungeon Schematic that hasn't been added: " + schematic.name);
            return;
        }
        this.schematics.remove(schematic.name);
    }

    public DungeonSchematic getSchematic(String name) {
        if (!this.schematics.containsKey(name)) {
            return null;
        }
        return this.schematics.get(name);
    }
}

