/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dispenser;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.Random;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class BaseProjectileDispenseBehaviour
extends ProjectileDispenseBehavior {
    protected ProjectileInfo projectileInfo;
    protected String oldProjectileName;
    protected Class<? extends BaseProjectileEntity> oldProjectileClass;

    public BaseProjectileDispenseBehaviour(ProjectileInfo projectileInfo) {
        this.projectileInfo = projectileInfo;
    }

    public BaseProjectileDispenseBehaviour(Class<? extends BaseProjectileEntity> oldProjectileClass, String oldProjectileName) {
        this.oldProjectileClass = oldProjectileClass;
        this.oldProjectileName = oldProjectileName;
    }

    public ItemStack func_82487_b(IBlockSource blockSource, ItemStack stack) {
        World world = blockSource.func_197524_h();
        IPosition position = DispenserBlock.func_149939_a((IBlockSource)blockSource);
        Direction facing = (Direction)blockSource.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        IProjectile iprojectile = this.func_82499_a(world, position, stack);
        if (iprojectile == null) {
            return stack;
        }
        iprojectile.func_70186_c((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e(), this.func_82500_b(), this.func_82498_a());
        world.func_217376_c((Entity)iprojectile);
        stack.func_77979_a(1);
        return stack;
    }

    protected IProjectile func_82499_a(World world, IPosition pos, ItemStack stack) {
        if (this.projectileInfo != null) {
            return this.projectileInfo.createProjectile(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        }
        if (this.oldProjectileClass != null) {
            return ProjectileManager.getInstance().createOldProjectile(this.oldProjectileClass, world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        }
        return null;
    }

    protected float func_82498_a() {
        return 0.0f;
    }

    protected float func_82500_b() {
        if (this.projectileInfo != null) {
            return (float)this.projectileInfo.velocity;
        }
        return 1.1f;
    }

    protected void func_82485_a(IBlockSource blockSource) {
        SoundEvent soundEvent = this.getDispenseSound();
        if (soundEvent == null || blockSource == null) {
            return;
        }
        blockSource.func_197524_h().func_184133_a(null, blockSource.func_180699_d(), soundEvent, SoundCategory.AMBIENT, 1.0f, 1.0f / (new Random().nextFloat() * 0.4f + 0.8f));
    }

    protected SoundEvent getDispenseSound() {
        if (this.projectileInfo != null) {
            return this.projectileInfo.getLaunchSound();
        }
        return ObjectManager.getSound(this.oldProjectileName);
    }
}

