/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.container;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.container.BaseContainer;
import com.lycanitesmobs.core.container.EquipmentSlot;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.tileentity.TileEntityEquipmentForge;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;

public class EquipmentForgeContainer
extends BaseContainer {
    public static final ContainerType<EquipmentForgeContainer> TYPE = (ContainerType)IForgeContainerType.create(EquipmentForgeContainer::new).setRegistryName("lycanitesmobs", "equipment_forge");
    public TileEntityEquipmentForge equipmentForge;

    public EquipmentForgeContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        this(windowId, playerInventory, (TileEntityEquipmentForge)playerInventory.field_70458_d.func_130014_f_().func_175625_s(BlockPos.func_218283_e((long)extraData.readLong())));
    }

    public EquipmentForgeContainer(int windowId, PlayerInventory playerInventory, TileEntityEquipmentForge equipmentForge) {
        super(TYPE, windowId);
        this.equipmentForge = equipmentForge;
        this.addPlayerSlots(playerInventory, 0, 0);
        this.inventoryStart = this.field_75151_b.size();
        int slots = 0;
        if (equipmentForge.func_70302_i_() > 0) {
            int slotSize = 18;
            int x = 8 + slotSize;
            int y = 38;
            EquipmentSlot equipmentSlotPiece = new EquipmentSlot(this, slots++, x + slotSize * 6, y, "piece");
            this.func_75146_a(equipmentSlotPiece);
            EquipmentSlot equipmentSlotBase = new EquipmentSlot(this, slots++, x + slotSize, y, "base");
            this.func_75146_a(equipmentSlotBase);
            EquipmentSlot equipmentSlotHead = new EquipmentSlot(this, slots++, x + slotSize * 2, y, "none");
            this.func_75146_a(equipmentSlotHead);
            equipmentSlotBase.addChildSlot(equipmentSlotHead);
            EquipmentSlot equipmentSlotTipA = new EquipmentSlot(this, slots++, x + slotSize * 3, y, "none");
            this.func_75146_a(equipmentSlotTipA);
            equipmentSlotHead.addChildSlot(equipmentSlotTipA);
            EquipmentSlot equipmentSlotTipB = new EquipmentSlot(this, slots++, x + slotSize * 2, y - slotSize, "none");
            this.func_75146_a(equipmentSlotTipB);
            equipmentSlotHead.addChildSlot(equipmentSlotTipB);
            EquipmentSlot equipmentSlotTipC = new EquipmentSlot(this, slots++, x + slotSize * 2, y + slotSize, "none");
            this.func_75146_a(equipmentSlotTipC);
            equipmentSlotHead.addChildSlot(equipmentSlotTipC);
            EquipmentSlot equipmentSlotPommel = new EquipmentSlot(this, slots++, x, y, "none");
            this.func_75146_a(equipmentSlotPommel);
            equipmentSlotBase.addChildSlot(equipmentSlotPommel);
        }
        this.inventoryFinish = this.inventoryStart + slots;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return this.equipmentForge != null;
    }

    public void onEquipmentPieceSlotChanged(EquipmentSlot equipmentSlot) {
        if (this.equipmentForge == null) {
            return;
        }
        this.clearPartSlots();
        EquipmentSlot slotBase = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 1);
        if (equipmentSlot.func_75216_d() && !slotBase.func_75216_d() && equipmentSlot.func_75211_c().func_77973_b() instanceof ItemEquipment) {
            EquipmentSlot slotHead = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 2);
            EquipmentSlot slotTipA = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 3);
            EquipmentSlot slotTipB = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 4);
            EquipmentSlot slotTipC = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 5);
            EquipmentSlot slotPommel = (EquipmentSlot)this.func_75139_a(this.inventoryStart + 6);
            ItemEquipment itemEquipment = (ItemEquipment)equipmentSlot.func_75211_c().func_77973_b();
            int axeIndex = 0;
            for (ItemStack partStack : itemEquipment.getEquipmentPartStacks(equipmentSlot.func_75211_c())) {
                ItemEquipmentPart itemEquipmentPart = itemEquipment.getEquipmentPart(partStack);
                if (itemEquipmentPart == null) continue;
                if ("base".equals(itemEquipmentPart.slotType)) {
                    slotBase.putStackWithoutUpdate(partStack);
                    continue;
                }
                if ("head".equals(itemEquipmentPart.slotType)) {
                    slotHead.putStackWithoutUpdate(partStack);
                    continue;
                }
                if ("blade".equals(itemEquipmentPart.slotType) || "pike".equals(itemEquipmentPart.slotType)) {
                    slotTipA.putStackWithoutUpdate(partStack);
                    continue;
                }
                if ("axe".equals(itemEquipmentPart.slotType)) {
                    if (axeIndex++ == 0) {
                        slotTipB.putStackWithoutUpdate(partStack);
                        continue;
                    }
                    slotTipC.putStackWithoutUpdate(partStack);
                    continue;
                }
                if (!"pommel".equals(itemEquipmentPart.slotType)) continue;
                slotPommel.putStackWithoutUpdate(partStack);
            }
        }
    }

    public void onEquipmentPartSlotChanged(EquipmentSlot equipmentSlot) {
        if (this.equipmentForge == null) {
            return;
        }
        Slot slotPiece = this.func_75139_a(this.inventoryStart);
        Slot slotBase = this.func_75139_a(this.inventoryStart + 1);
        Slot slotHead = this.func_75139_a(this.inventoryStart + 2);
        Slot slotTipA = this.func_75139_a(this.inventoryStart + 3);
        Slot slotTipB = this.func_75139_a(this.inventoryStart + 4);
        Slot slotTipC = this.func_75139_a(this.inventoryStart + 5);
        Slot slotPommel = this.func_75139_a(this.inventoryStart + 6);
        ItemEquipment itemEquipment = (ItemEquipment)ObjectManager.getItem("equipment");
        ItemStack pieceStack = new ItemStack((IItemProvider)itemEquipment);
        if (slotBase.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotBase.func_75211_c(), 0);
        }
        if (slotHead.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotHead.func_75211_c(), 1);
        }
        if (slotTipA.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotTipA.func_75211_c(), 2);
        }
        if (slotTipB.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotTipB.func_75211_c(), 3);
        }
        if (slotTipC.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotTipC.func_75211_c(), 4);
        }
        if (slotPommel.func_75216_d()) {
            itemEquipment.addEquipmentPart(pieceStack, slotPommel.func_75211_c(), 5);
        }
        slotPiece.func_75215_d(pieceStack);
    }

    public void clearPartSlots() {
        for (int i = 1; i <= 6; ++i) {
            Slot slot = this.func_75139_a(this.inventoryStart + i);
            if (!(slot instanceof EquipmentSlot)) continue;
            EquipmentSlot equipmentSlot = (EquipmentSlot)slot;
            equipmentSlot.putStackWithoutUpdate(ItemStack.field_190927_a);
        }
    }

    public boolean isEquipmentValid() {
        Slot slotBase = this.func_75139_a(this.inventoryStart + 1);
        Slot slotHead = this.func_75139_a(this.inventoryStart + 2);
        Slot slotTipA = this.func_75139_a(this.inventoryStart + 3);
        Slot slotTipB = this.func_75139_a(this.inventoryStart + 4);
        Slot slotTipC = this.func_75139_a(this.inventoryStart + 5);
        if (!slotBase.func_75216_d() || !slotHead.func_75216_d()) {
            return false;
        }
        return slotTipA.func_75216_d() || slotTipB.func_75216_d() || slotTipC.func_75216_d();
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int slotID) {
        return ItemStack.field_190927_a;
    }
}

