/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.container;

import com.lycanitesmobs.core.container.BaseSlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public abstract class BaseContainer
extends Container {
    public Map<Integer, String> specialSlots = new HashMap<Integer, String>();
    public int playerInventoryStart = -1;
    public int playerInventoryFinish = -1;
    public int inventoryStart = -1;
    public int inventoryFinish = -1;
    public int specialStart = -1;
    public int specialFinish = -1;

    public BaseContainer(ContainerType<?> type, int windowId) {
        super(type, windowId);
    }

    public Slot addSlot(IInventory inventory, int slotIndex, int x, int y) {
        return this.func_75146_a(new BaseSlot(inventory, slotIndex, x, y));
    }

    public void addPlayerSlots(PlayerInventory playerInventory, int offsetX, int offsetY) {
        this.playerInventoryStart = this.field_75151_b.size();
        this.addSlotGrid((IInventory)playerInventory, 8, 142, 1, 0, 8);
        this.addSlotGrid((IInventory)playerInventory, 8, 84, 3, 9, 35);
        this.playerInventoryFinish = this.field_75151_b.size() - 1;
    }

    public void addSlotGrid(IInventory inventory, int x, int y, int totalRows, int start, int finish) {
        int column;
        int row;
        int totalSlots = finish - start + 1;
        if (totalSlots < 1) {
            return;
        }
        int excessSlots = totalSlots % totalRows;
        int totalColumns = (totalSlots - excessSlots) / totalRows;
        int slot = 0;
        for (row = 0; row < totalRows; ++row) {
            for (column = 0; column < totalColumns; ++column) {
                this.addSlot(inventory, start + slot, x + column * 18, y + row * 18);
                ++slot;
            }
        }
        ++row;
        for (column = 0; column < excessSlots; ++column) {
            this.addSlot(inventory, start + slot, x + column * 18, y + row * 18);
            ++slot;
        }
    }

    public void addSlotGrid(IInventory inventory, int x, int y, int totalRows) {
        this.addSlotGrid(inventory, x, y, totalRows, 0);
    }

    public void addSlotGrid(IInventory inventory, int x, int y, int totalRows, int start) {
        this.addSlotGrid(inventory, x, y, totalRows, start, inventory.func_70302_i_() - 1);
    }

    public void addSlotsByColumn(IInventory inventory, int x, int y, int columnMax, int start, int finish) {
        int row = 0;
        int column = 0;
        for (int slot = 0; slot <= finish; ++slot) {
            if (column >= columnMax) {
                ++row;
                column = 0;
            }
            this.addSlot(inventory, start + slot, x + column * 18, y + row * 18);
            ++column;
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotID) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        if (slot == null || !slot.func_75216_d()) {
            return itemStack;
        }
        ItemStack slotStack = slot.func_75211_c();
        itemStack = slotStack.func_77946_l();
        if (this.isPlayerSlot(slotID)) {
            if (this.specialStart >= 0 && this.specialFinish >= 0) {
                for (int i = this.specialStart; i <= this.specialFinish; ++i) {
                    Slot targetSlot;
                    if (i >= this.field_75151_b.size() || !(targetSlot = (Slot)this.field_75151_b.get(i)).func_75214_a(itemStack) || this.func_75135_a(slotStack, i, i + 1, false)) continue;
                    return ItemStack.field_190927_a;
                }
            }
            if (this.inventoryStart >= 0 && this.inventoryFinish >= 0 && this.inventoryStart < this.inventoryFinish && !this.func_75135_a(slotStack, this.inventoryStart, this.inventoryFinish + 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (this.playerInventoryFinish >= 0 && !this.func_75135_a(slotStack, this.playerInventoryStart, this.playerInventoryFinish, true)) {
            return ItemStack.field_190927_a;
        }
        if (slotStack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isPlayerSlot(int slotID) {
        return slotID >= this.playerInventoryStart && slotID <= this.playerInventoryFinish;
    }

    public boolean sortToSpecialSlots(ItemStack slotStack) {
        return true;
    }

    public String getSpecialSlot(int slotID) {
        if (!this.specialSlots.containsKey(slotID)) {
            return null;
        }
        return this.specialSlots.get(slotID);
    }

    public boolean func_75145_c(PlayerEntity entityplayer) {
        return true;
    }
}

