/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block.effect;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.block.BlockFireBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockFrostfire
extends BlockFireBase {
    public BlockFrostfire(Block.Properties properties) {
        this(properties, "frostfire");
    }

    public BlockFrostfire(Block.Properties properties, String name) {
        super(properties, LycanitesMobs.modInfo, name);
        this.tickRate = 30;
        this.dieInRain = false;
        this.triggerTNT = false;
        this.agingRate = 3;
        this.spreadChance = 1.0f;
        this.removeOnTick = false;
        this.removeOnNoFireTick = false;
    }

    @Override
    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150432_aD || block == Blocks.field_150403_cj;
    }

    @Override
    public boolean isBlockFireSource(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return state.func_177230_c() == Blocks.field_150433_aE || state.func_177230_c() == Blocks.field_196604_cC;
    }

    @Override
    public int getBlockFlammability(IBlockReader world, BlockPos pos, Direction face) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150432_aD) {
            return 20;
        }
        return 0;
    }

    @Override
    protected boolean canDie(World world, BlockPos pos) {
        return false;
    }

    @Override
    public void burnBlockReplace(World world, BlockPos pos, int newFireAge) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150432_aD) {
            world.func_180501_a(pos, Blocks.field_150403_cj.func_176223_P(), 3);
            return;
        }
        super.burnBlockReplace(world, pos, newFireAge);
    }

    @Override
    public void burnBlockDestroy(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150432_aD) {
            world.func_180501_a(pos, Blocks.field_150403_cj.func_176223_P(), 3);
            return;
        }
        super.burnBlockDestroy(world, pos);
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(blockState, world, pos, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity entityLiving = (LivingEntity)entity;
            EffectInstance effect = new EffectInstance(Effects.field_76421_d, 60, 0);
            if (entityLiving.func_70687_e(effect)) {
                entityLiving.func_195064_c(effect);
            } else {
                return;
            }
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        entity.func_70097_a(DamageSource.field_76376_m, 2.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        if (random.nextInt(24) == 0) {
            world.func_184134_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ObjectManager.getSound("frostfire"), SoundCategory.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        if (random.nextInt(100) == 0) {
            x = (float)pos.func_177958_n() + random.nextFloat();
            z = (float)pos.func_177952_p() + random.nextFloat();
            world.func_195594_a((IParticleData)ParticleTypes.field_197593_D, x, y, z, 0.0, 0.0, 0.0);
        }
        super.func_180655_c(state, world, pos, random);
    }
}

