/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.container.EquipmentForgeContainerProvider;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.tileentity.TileEntityEquipmentForge;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockEquipmentForge
extends BlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public int level;

    public BlockEquipmentForge(Block.Properties properties, ModInfo group, int level) {
        super(properties);
        this.group = group;
        this.level = level;
        this.blockName = level <= 1 ? "equipmentforge_lesser" : (level == 2 ? "equipmentforge_greater" : "equipmentforge_master");
        this.setRegistryName(this.group.modid, this.blockName.toLowerCase());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, entity, itemStack);
    }

    public boolean hasTileEntity(BlockState blockState) {
        return true;
    }

    public TileEntity createTileEntity(BlockState blockState, IBlockReader world) {
        TileEntityEquipmentForge tileEntityEquipmentForge = new TileEntityEquipmentForge();
        tileEntityEquipmentForge.setLevel(this.level);
        return tileEntityEquipmentForge;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && player instanceof ServerPlayerEntity && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityEquipmentForge) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new EquipmentForgeContainerProvider((TileEntityEquipmentForge)tileEntity), buf -> buf.func_179255_a(pos));
        }
        return true;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity != null && tileEntity.func_145842_c(eventID, eventParam);
    }
}

