/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.lycanitesmobs.LycanitesMobs;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class StreamLoader {
    public static StreamLoader CLIENT;
    public static StreamLoader SERVER;
    public static StreamLoader COMMON;
    private String rootPath;
    private String domain;

    public static void initAll(String domain) {
        CLIENT = new StreamLoader("assets", domain);
        SERVER = new StreamLoader("data", domain);
        COMMON = new StreamLoader("common", domain);
        LycanitesMobs.logDebug("", "All FileLoaders initialised successfully.");
    }

    public StreamLoader(String type, String domain) {
        this.domain = domain;
        this.rootPath = type + "/" + domain;
    }

    public File getJarFile() {
        try {
            Path path = new File("mods").toPath();
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                if (!filePath.getFileName().toString().toLowerCase().contains(this.domain)) continue;
                return filePath.toFile();
            }
            throw new RuntimeException("Unable to locate mod jar file.");
        }
        catch (Exception e) {
            LycanitesMobs.logError("Error locating mod jar file.");
            throw new RuntimeException(e);
        }
    }

    public InputStream getStream(String subPath) {
        return this.getClass().getResourceAsStream("/" + this.rootPath + "/" + subPath);
    }

    public List<InputStream> getStreams(String dir) {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        try {
            JarFile jar = new JarFile(this.getJarFile());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(this.rootPath + "/" + dir + "/") || name.endsWith("/")) continue;
                InputStream inputStream = this.getClass().getResourceAsStream("/" + name);
                if (inputStream == null) {
                    throw new RuntimeException("Error streaming file from mod jar: /" + name);
                }
                inputStreams.add(inputStream);
            }
            jar.close();
        }
        catch (Exception e) {
            LycanitesMobs.logError("Error reading files within jar file for dir: " + dir);
            throw new RuntimeException(e);
        }
        return inputStreams;
    }
}

