/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.info.ModInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class JSONLoader {
    public File getMinecraftDir() {
        return new File(".");
    }

    public void loadAllJson(ModInfo modInfo, String loadGroup, String dataPath, String mapKey, boolean loadCustom, @Nullable String jsonType, FileLoader fileLoader, StreamLoader streamLoader) {
        LycanitesMobs.logDebug(loadGroup, "Loading JSON " + loadGroup + "...");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> jsons = new HashMap<String, JsonObject>();
        HashMap<String, JsonObject> defaultJsons = new HashMap<String, JsonObject>();
        if (fileLoader.ready) {
            Path path = fileLoader.getPath(dataPath);
            this.loadJsonObjects(gson, path, defaultJsons, mapKey, jsonType);
        } else {
            this.loadJsonObjects(gson, streamLoader.getStreams(dataPath), defaultJsons, mapKey, jsonType);
        }
        String configPath = this.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        File customDir = new File(configPath + dataPath);
        customDir.mkdirs();
        Path customPath = customDir.toPath();
        HashMap<String, JsonObject> customJsons = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, customPath, customJsons, mapKey, jsonType);
        this.writeDefaultJSONObjects(gson, defaultJsons, customJsons, jsons, loadCustom, dataPath);
        LycanitesMobs.logDebug(loadGroup, "Loading " + jsons.size() + " " + loadGroup + "...");
        for (String jsonName : jsons.keySet()) {
            JsonObject json;
            try {
                json = (JsonObject)jsons.get(jsonName);
                LycanitesMobs.logDebug(loadGroup, "Loading " + loadGroup + " JSON: " + json);
                if (json.isJsonNull()) {
                    throw new RuntimeException("Tried to load JSON data from a null json object.");
                }
            }
            catch (JsonParseException e) {
                LycanitesMobs.logError("Parsing error loading JSON " + loadGroup + ": " + jsonName);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LycanitesMobs.logError("There was a problem loading JSON " + loadGroup + ": " + jsonName);
                throw new RuntimeException(e);
            }
            this.parseJson(modInfo, loadGroup, json);
        }
    }

    public abstract void parseJson(ModInfo var1, String var2, JsonObject var3);

    public void loadJsonObjects(Gson gson, List<InputStream> inputStreams, Map<String, JsonObject> jsonObjectMap, String mapKey, String jsonType) {
        for (InputStream inputStream : inputStreams) {
            JsonObject json = this.loadJsonObject(gson, inputStream);
            boolean validJSON = true;
            if (jsonType != null) {
                validJSON = !json.has("type") ? false : jsonType.equalsIgnoreCase(json.get("type").getAsString());
            }
            if (!validJSON) continue;
            jsonObjectMap.put(json.get(mapKey).getAsString(), json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject loadJsonObject(Gson gson, InputStream inputStream) {
        try {
            JsonObject json;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            if (json.isJsonNull()) {
                throw new RuntimeException("Unable to load JSON from Input Stream: " + inputStream);
            }
            inputStream.close();
            return json;
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to read file from path.\n" + e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJsonObjects(Gson gson, Path path, Map<String, JsonObject> jsonObjectMap, String mapKey, String jsonType) {
        if (path == null) {
            return;
        }
        try {
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                Path relativePath = path.relativize(filePath);
                if (!"json".equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                BufferedReader reader = null;
                try {
                    try {
                        reader = Files.newBufferedReader(filePath);
                        JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                        boolean validJSON = true;
                        if (jsonType != null) {
                            validJSON = !json.has("type") ? false : jsonType.equalsIgnoreCase(json.get("type").getAsString());
                        }
                        if (!validJSON) continue;
                        jsonObjectMap.put(json.get(mapKey).getAsString(), json);
                    }
                    catch (JsonParseException e) {
                        LycanitesMobs.logWarning("", "Parsing error loading JSON " + relativePath + "\n" + e.toString());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        LycanitesMobs.logWarning("", "There was a problem loading JSON " + relativePath + "\n" + e.toString());
                        e.printStackTrace();
                    }
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to read files from directory.\n" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject loadJsonObject(Gson gson, Path path) {
        if (path == null) {
            return null;
        }
        try {
            BufferedReader reader = null;
            try {
                JsonObject json;
                reader = Files.newBufferedReader(path);
                JsonObject jsonObject = json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                return jsonObject;
            }
            catch (JsonParseException e) {
                LycanitesMobs.logWarning("", "Parsing error loading JSON from path: " + path + "\n" + e.toString());
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "There was a problem loading JSON from path: " + path + "\n" + e.toString());
                e.printStackTrace();
                return null;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to read file from path.\n" + e.toString());
        }
        return null;
    }

    public void writeDefaultJSONObjects(Gson gson, Map<String, JsonObject> defaultJSONs, Map<String, JsonObject> customJSONs, Map<String, JsonObject> mixedJSONs, boolean custom, String dataPath) {
        for (String jsonName : defaultJSONs.keySet()) {
            try {
                JsonObject defaultJSON = defaultJSONs.get(jsonName);
                boolean loadDefault = true;
                JsonObject customJSON = null;
                if (customJSONs.containsKey(jsonName)) {
                    loadDefault = false;
                    customJSON = customJSONs.get(jsonName);
                    if (customJSON.has("loadDefault")) {
                        loadDefault = customJSON.get("loadDefault").getAsBoolean();
                    }
                }
                if (loadDefault) {
                    this.saveJsonObject(gson, defaultJSON, jsonName, dataPath);
                    mixedJSONs.put(jsonName, defaultJSON);
                    continue;
                }
                if (customJSON == null) continue;
                mixedJSONs.put(jsonName, customJSON);
            }
            catch (JsonParseException e) {
                LycanitesMobs.logWarning("", "Parsing error loading JSON: " + jsonName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "There was a problem loading JSON: " + jsonName);
                e.printStackTrace();
            }
        }
        if (custom) {
            for (String jsonName : customJSONs.keySet()) {
                if (defaultJSONs.containsKey(jsonName)) continue;
                mixedJSONs.put(jsonName, customJSONs.get(jsonName));
            }
        }
    }

    public JsonObject writeDefaultJSONObject(Gson gson, String jsonName, JsonObject defaultJSON, JsonObject customJSON) {
        try {
            boolean loadDefault = true;
            if (customJSON != null) {
                loadDefault = false;
                if (customJSON.has("loadDefault")) {
                    loadDefault = customJSON.get("loadDefault").getAsBoolean();
                }
            }
            if (loadDefault) {
                this.saveJsonObject(gson, defaultJSON, jsonName, "");
                return defaultJSON;
            }
            if (customJSON != null) {
                return customJSON;
            }
        }
        catch (JsonParseException e) {
            LycanitesMobs.logWarning("", "Parsing error loading JSON: " + jsonName);
            throw new RuntimeException("Error Parsing JSON: " + jsonName + "\n" + (Object)((Object)e));
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem loading JSON: " + jsonName);
            throw new RuntimeException("Error Loading JSON: " + jsonName + "\n" + e);
        }
        return null;
    }

    public void saveJsonObject(Gson gson, JsonObject jsonObject, String name, String dataPath) {
        String configPath = this.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        try {
            File jsonFile = new File(configPath + (!"".equals(dataPath) ? dataPath + "/" : "") + name + ".json");
            jsonFile.getParentFile().mkdirs();
            jsonFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(jsonFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.append(gson.toJson((JsonElement)jsonObject));
            outputStreamWriter.close();
            outputStream.close();
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to save JSON into the config folder.");
            e.printStackTrace();
        }
    }
}

