/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer.layer;

import com.lycanitesmobs.client.renderer.IItemModelRenderer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerItem {
    public IItemModelRenderer renderer;
    public String name;
    public String textureSuffix;
    public boolean glow = false;
    public int blending = 0;
    public Vector2f scrollSpeed;
    public Vector4f colorFadeSpeed;

    public LayerItem(IItemModelRenderer renderer, String name) {
        this.renderer = renderer;
        this.name = name;
    }

    public Vector4f getPartColor(String partName, ItemStack itemStack, float loop) {
        if (this.colorFadeSpeed != null) {
            float red = 1.0f;
            if (this.colorFadeSpeed.getX() != 0.0f) {
                red = loop % this.colorFadeSpeed.getX() / this.colorFadeSpeed.getX() * 2.0f;
            }
            if (red > 1.0f) {
                red = -(red - 1.0f);
            }
            float green = 1.0f;
            if (this.colorFadeSpeed.getY() != 0.0f) {
                green = loop % this.colorFadeSpeed.getY() / this.colorFadeSpeed.getY() * 2.0f;
            }
            if (green > 1.0f) {
                green = -(green - 1.0f);
            }
            float blue = 1.0f;
            if (this.colorFadeSpeed.getZ() != 0.0f) {
                blue = loop % this.colorFadeSpeed.getZ() / this.colorFadeSpeed.getZ() * 2.0f;
            }
            if (blue > 1.0f) {
                blue = -(blue - 1.0f);
            }
            float alpha = 1.0f;
            if (this.colorFadeSpeed.getW() != 0.0f) {
                alpha = loop % this.colorFadeSpeed.getW() / this.colorFadeSpeed.getW() * 2.0f;
            }
            if (alpha > 1.0f) {
                alpha = -(alpha - 1.0f);
            }
            return new Vector4f(red, green, blue, alpha);
        }
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getLayerTexture(BaseCreatureEntity entity) {
        return entity.getTexture(this.textureSuffix);
    }

    public void onRenderStart(ItemStack itemStack) {
        if (this.glow) {
            GlStateManager.disableLighting();
            int i = 0xF000F0;
            int j = i % 65536;
            int k = i / 65536;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        }
        if (this.blending == BLEND.ADD.id) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else if (this.blending == BLEND.SUB.id) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }

    public void onRenderFinish(ItemStack itemStack) {
        if (this.glow) {
            GlStateManager.enableLighting();
        }
    }

    public Vector2f getTextureOffset(String partName, ItemStack itemStack, float loop) {
        if (this.scrollSpeed == null) {
            this.scrollSpeed = new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f(loop * this.scrollSpeed.x, loop * this.scrollSpeed.y);
    }

    public static enum BLEND {
        NORMAL(0),
        ADD(1),
        SUB(2);

        public final int id;

        private BLEND(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

