/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.google.common.collect.Lists;
import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.model.ModelProjectileBase;
import com.lycanitesmobs.client.model.ModelProjectileObj;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectileModel
extends EntityRenderer<BaseProjectileEntity>
implements IEntityRenderer<BaseProjectileEntity, ModelProjectileBase> {
    protected ModelProjectileBase renderModel;
    protected ModelProjectileBase defaultModel;
    protected final List<LayerRenderer<BaseProjectileEntity, ModelProjectileBase>> renderLayers = Lists.newArrayList();

    public RenderProjectileModel(EntityRendererManager renderManager, String projectileName) {
        super(renderManager);
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(projectileName);
        this.renderModel = projectileInfo != null ? ModelManager.getInstance().getProjectileModel(projectileInfo) : ModelManager.getInstance().getOldProjectileModel(projectileName);
        if (this.renderModel == null) {
            return;
        }
        this.defaultModel = this.renderModel;
        this.renderModel.addCustomLayers(this);
    }

    public void func_76986_a(BaseProjectileEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        try {
            GlStateManager.enableAlphaTest();
            if (!this.bindEntityTexture(entity)) {
                return;
            }
            GlStateManager.translatef((float)((float)x), (float)((float)y - 0.25f), (float)((float)z));
            GlStateManager.scalef((float)0.25f, (float)0.25f, (float)0.25f);
            GlStateManager.rotatef((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
            if (!(this.renderModel instanceof ModelProjectileObj)) {
                this.renderModel.func_78088_a(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f);
            } else {
                ((ModelProjectileObj)this.renderModel).generateAnimationFrames(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f);
                this.renderModel.render(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f, null, false);
                for (LayerRenderer<BaseProjectileEntity, ModelProjectileBase> renderLayer : this.renderLayers) {
                    if (!(renderLayer instanceof LayerProjectileBase)) continue;
                    this.renderModel.render(entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 1.0f, (LayerProjectileBase)renderLayer, false);
                }
                ((ModelProjectileObj)this.renderModel).clearAnimationFrames();
            }
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableRescaleNormal();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.enableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
    }

    public ModelProjectileBase getMainModel() {
        return this.renderModel;
    }

    public ModelProjectileBase getEntityModel() {
        return this.getMainModel();
    }

    public final boolean addLayer(LayerRenderer<BaseProjectileEntity, ModelProjectileBase> layer) {
        return this.renderLayers.add(layer);
    }

    protected boolean bindEntityTexture(BaseProjectileEntity entity) {
        ResourceLocation texture = this.func_110775_a(entity);
        if (texture == null) {
            return false;
        }
        this.func_110776_a(texture);
        return true;
    }

    @Nullable
    protected ResourceLocation func_110775_a(BaseProjectileEntity entity) {
        return entity.getTexture();
    }
}

