/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateBiped;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelWraamon
extends ModelTemplateBiped {
    public ModelWraamon() {
        this(1.0f);
    }

    public ModelWraamon(float shadowSize) {
        this.initModel("wraamon", LycanitesMobs.modInfo, "entity/wraamon");
        this.lookHeadScaleX = 0.8f;
        this.lookHeadScaleY = 0.8f;
        this.lookNeckScaleX = 0.2f;
        this.lookNeckScaleY = 0.2f;
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "glow", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        if (this.currentModelState != null) {
            if (this.currentModelState.getBoolean("standing")) {
                if (partName.equals("body")) {
                    this.rotate(-45.0f, 0.0f, 0.0f);
                } else if (partName.equals("head")) {
                    this.rotate(30.0f, 0.0f, 0.0f);
                } else if (partName.contains("leg")) {
                    this.rotate(45.0f, 0.0f, 0.0f);
                } else if (partName.contains("tail")) {
                    this.rotate(50.0f, 0.0f, 0.0f);
                }
            }
            if (this.currentModelState.getFloat("standingChangeTime") <= 0.0f) {
                this.currentModelState.setBoolean("standing", !this.currentModelState.getBoolean("standing"));
                this.currentModelState.setFloat("standingChangeTime", 40.0f + 160.0f * entity.func_70681_au().nextFloat());
            }
            if (partName.equals("body")) {
                this.currentModelState.setFloat("standingChangeTime", this.currentModelState.getFloat("standingChangeTime") - 1.0f);
            }
        }
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("nose")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.1f)), (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.4f)) * 0.1f)), 0.0f);
        } else if (partName.equals("tailleft")) {
            float rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            float rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
            this.rotate(rotX, rotY, 0.0f);
        } else if (partName.equals("tailright")) {
            float rotX = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f);
            float rotY = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f);
            this.rotate(rotX, rotY, 0.0f);
        }
    }
}

